<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\EmailTemplateService;
use App\Models\EmailTemplate;
use App\Models\EmailTemplateType;

class TestEmailTemplateTypeStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:test-template-type-status {templateSlug?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Test email template type status functionality';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $templateSlug = $this->argument('templateSlug');
        
        if ($templateSlug) {
            $this->testSpecificTemplate($templateSlug);
        } else {
            $this->testAllTemplates();
        }
    }

    private function testSpecificTemplate($templateSlug)
    {
        $this->info("Testing template type status for: {$templateSlug}");
        
        $status = EmailTemplateService::getTemplateTypeStatus($templateSlug);
        
        $this->line("Status: " . ($status['active'] ? 'Active' : 'Inactive'));
        $this->line("Message: " . $status['message']);
        
        if (isset($status['type_name'])) {
            $this->line("Type Name: " . $status['type_name']);
        }
        
        // Test if email can be sent
        $canSend = EmailTemplateService::isTemplateTypeActive($templateSlug);
        $this->line("Can Send Email: " . ($canSend ? 'Yes' : 'No'));
    }

    private function testAllTemplates()
    {
        $this->info("Testing all email templates...");
        
        $templates = EmailTemplate::with('templateType')->get();
        
        $this->table(
            ['Template', 'Type', 'Template Active', 'Type Active', 'Can Send'],
            $templates->map(function ($template) {
                $typeStatus = EmailTemplateService::getTemplateTypeStatus($template->slug);
                return [
                    $template->name,
                    $template->templateType ? $template->templateType->name : 'No Type',
                    $template->is_active ? 'Yes' : 'No',
                    $template->templateType ? ($template->templateType->is_active ? 'Yes' : 'No') : 'N/A',
                    $typeStatus['active'] ? 'Yes' : 'No'
                ];
            })
        );
    }
}