<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use PDF;
use Auth;
use Helper;
use App\Models\User;
use App\Models\Banner;
use App\Models\Order;
use App\Models\Comment;
use App\Models\Package;
use App\Models\Setting;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    public function login(Request $request)
    {
      if ($request->isMethod('get'))
      {
        return view('Admin.login');
      }
      else
      {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|string',
        ]);

        if (auth()->attempt(['email' => $request->email, 'password' => $request->password]))
        {
          if (auth()->user()->is_admin == 1)
          {
            return redirect()->intended('/admin/dashboard');
          }
          else
          {
            //return redirect()->intended('/user/dashboard')->with('success', 'Logged in successfully!');
          }
        }
        else
        {
          return redirect('/admin/login')->with('error', 'Invalid credentials. Try again.');
        }

      } 
    }

    public function dashboard(Request $request)
    {
        if ($request->isMethod('get'))
        {
          return view('Admin.dashboard');
        }
    }

    public function profile(Request $request)
    {
      if ($request->isMethod('get'))
      {
        if(Auth::check())
        {
          $user = Auth::user();

          $details['user'] = $user;

          return view('Admin.profile', $details);
        }
      }
      else
      {
        $request->validate([
          'name' => 'required',
          'email' => 'required|email',
          'phone_number' => 'required',
      ], [
          'name.required' => 'Please Enter Name',
          'email.required' => 'Please Enter Email Address',
          'email.email' => 'Please Enter Valid Email Address',
          'phone_number.required' => 'Please Enter Phone Number',
      ]);

        $user_data = User::where('is_admin', '1')->first();

        $user_data->name = $request->name;
        $user_data->email = $request->email;
        $user_data->phone_number = $request->phone_number;
        $user_data->updated_at = date("Y-m-d H:i:s");

        $update_user = $user_data->update();

        if($update_user)
        {
          return redirect()->route('admin.profile')->with('success', 'Profile Details Updated Successfully!'); 
        }
      }
    }

    public function changePassword(Request $request)
    {
      $user = Auth::user();

      if($request->isMethod('get'))
      {
        $details['user'] = $user;

        return view('Admin.changePassword', $details);
      }
      else
      {
        if (!Hash::check($request->current_password, $user->password))
        {
          return redirect('/admin/changePassword')->with('error', 'Current password is incorrect!');
        }
        else
        {
          if($request->new_password != $request->confirm_password)
          {
            return redirect('/admin/changePassword')->with('error', 'Please Enter Correct Confirm Password!');
          }
          else
          {
            $user->password = Hash::make($request->new_password);
            $user->save();

            return redirect()->route('admin.changePassword')->with('success', 'Password Changed Successfully!'); 
          }
        }
      }
    }

    public function update_password(Request $request)
    {
        $user = Auth::user();
      
      if (!Hash::check($request->current_password, $user->password))
      {
        $data['confirm'] = 0;
        $data['msg'] = 'Current password is incorrect!';

        return $data;
      }
      else
      {
        if($request->new_password != $request->confirm_password)
        {
         $data['confirm'] = 0;
         $data['msg'] = 'Please Enter Correct Confirm Password!';

         return $data; 
        }
        else
        {
          $user->password = Hash::make($request->new_password);
          $user->save();

          $data['confirm'] = 1;
          $data['msg'] = 'Password Changed Successfully!';

          return $data;
        }
      }
    }

    public function logout()
    {
      auth()->logout();
      return redirect()->route('admin.login');
    }
}