<?php

namespace App\Livewire\Admin;

use Livewire\Component;

class FlashMessage extends Component
{
    public $messages = [];
    public $showMessages = false;

    protected $listeners = [
        'flashMessage' => 'showMessage',
        'clearMessages' => 'clearMessages'
    ];

    public function mount()
    {
        $this->loadSessionMessages();
    }

    public function showMessage($type, $message, $title = null, $duration = 5000)
    {
        $this->messages[] = [
            'id' => uniqid(),
            'type' => $type,
            'title' => $title,
            'message' => $message,
            'duration' => $duration,
            'timestamp' => now()
        ];

        $this->showMessages = true;
        
        // Auto-remove message after duration
        if ($duration > 0) {
            $this->dispatch('autoRemoveMessage', $this->messages[count($this->messages) - 1]['id'], $duration);
        }
    }

    public function removeMessage($messageId)
    {
        $this->messages = array_filter($this->messages, function ($message) use ($messageId) {
            return $message['id'] !== $messageId;
        });

        if (empty($this->messages)) {
            $this->showMessages = false;
        }
    }

    public function clearMessages()
    {
        $this->messages = [];
        $this->showMessages = false;
    }

    public function loadSessionMessages()
    {
        if (session()->has('success')) {
            $messageData = session('success');
            if (is_array($messageData)) {
                $this->showMessage('success', $messageData['message'] ?? '', $messageData['title'] ?? null, $messageData['duration'] ?? 5000);
            } else {
                $this->showMessage('success', $messageData);
            }
            session()->forget('success');
        }

        if (session()->has('error')) {
            $messageData = session('error');
            if (is_array($messageData)) {
                $this->showMessage('error', $messageData['message'] ?? '', $messageData['title'] ?? null, $messageData['duration'] ?? 8000);
            } else {
                $this->showMessage('error', $messageData);
            }
            session()->forget('error');
        }

        if (session()->has('warning')) {
            $messageData = session('warning');
            if (is_array($messageData)) {
                $this->showMessage('warning', $messageData['message'] ?? '', $messageData['title'] ?? null, $messageData['duration'] ?? 6000);
            } else {
                $this->showMessage('warning', $messageData);
            }
            session()->forget('warning');
        }

        if (session()->has('info')) {
            $messageData = session('info');
            if (is_array($messageData)) {
                $this->showMessage('info', $messageData['message'] ?? '', $messageData['title'] ?? null, $messageData['duration'] ?? 5000);
            } else {
                $this->showMessage('info', $messageData);
            }
            session()->forget('info');
        }
    }

    public function render()
    {
        return view('livewire.admin.flash-message');
    }
}