<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmailTemplateType extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'slug',
        'description',
        'color',
        'icon',
        'is_active',
        'sort_order',
        'settings',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'settings' => 'array',
    ];

    /**
     * Get the email templates for this type
     */
    public function emailTemplates()
    {
        return $this->hasMany(EmailTemplate::class, 'type', 'slug');
    }

    /**
     * Scope for active types
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope for ordering by sort_order
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('name');
    }

    /**
     * Get the type color with fallback
     */
    public function getColorAttribute($value)
    {
        return $value ?: '#007bff';
    }

    /**
     * Get the type icon with fallback
     */
    public function getIconAttribute($value)
    {
        return $value ?: 'fas fa-envelope';
    }

    /**
     * Get templates count for this type
     */
    public function getTemplatesCountAttribute()
    {
        return $this->emailTemplates()->count();
    }
}