<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LearnerFormField extends Model
{
    use HasFactory;

    protected $fillable = [
        'learner_form_id',
        'field_name',
        'field_label',
        'field_type',
        'field_options',
        'is_required',
        'placeholder',
        'help_text',
        'sort_order',
        'is_active',
    ];

    protected $casts = [
        'is_required' => 'boolean',
        'is_active' => 'boolean',
        'field_options' => 'array',
        'sort_order' => 'integer',
    ];

    /**
     * Get the learner form that owns this field.
     */
    public function learnerForm(): BelongsTo
    {
        return $this->belongsTo(LearnerForm::class);
    }

    /**
     * Scope to get active fields.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to order by sort order.
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }
}
