<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withProviders([
        App\Providers\AppServiceProvider::class,
   //     App\Providers\AuthServiceProvider::class,
//App\Providers\EventServiceProvider::class,
        App\Providers\FortifyServiceProvider::class, // <= you added this earlier
    ])
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // ✅ Spatie permission middleware aliases
        $middleware->alias([
            'role'                => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission'          => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission'  => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            'maintenance'         => \App\Http\Middleware\MaintenanceModeMiddleware::class,
        ]);
        
        // ✅ Global middleware for maintenance mode and user active status
        $middleware->web(append: [
            \App\Http\Middleware\MaintenanceModeMiddleware::class,
            \App\Http\Middleware\CheckUserActive::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })
    ->create();
