<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, update any empty strings to NULL
        DB::table('users')->where('date_of_birth', '')->update(['date_of_birth' => null]);
        DB::table('users')->where('phone', '')->update(['phone' => null]);
        DB::table('users')->where('address', '')->update(['address' => null]);
        
        // Then modify the columns to ensure they're properly nullable
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->change();
            $table->text('address')->nullable()->change();
            $table->date('date_of_birth')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable(false)->change();
            $table->text('address')->nullable(false)->change();
            $table->date('date_of_birth')->nullable(false)->change();
        });
    }
};