<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('learner_form_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('learner_form_id')->constrained()->onDelete('cascade');
            $table->string('field_name');
            $table->string('field_label');
            $table->enum('field_type', ['text', 'email', 'number', 'textarea', 'select', 'checkbox', 'radio', 'date']);
            $table->text('field_options')->nullable(); // JSON for select, radio options
            $table->boolean('is_required')->default(false);
            $table->text('placeholder')->nullable();
            $table->text('help_text')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('learner_form_fields');
    }
};