<?php

namespace Database\Seeders;

use App\Models\EmailTemplateType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EmailTemplateTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            [
                'name' => 'General',
                'slug' => 'general',
                'description' => 'General purpose email templates',
                'color' => '#007bff',
                'icon' => 'fas fa-envelope',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Learner',
                'slug' => 'learner',
                'description' => 'Templates for learner communications',
                'color' => '#28a745',
                'icon' => 'fas fa-user-graduate',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Administrator',
                'slug' => 'admin',
                'description' => 'Templates for administrator communications',
                'color' => '#dc3545',
                'icon' => 'fas fa-user-shield',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'System',
                'slug' => 'system',
                'description' => 'System-generated email templates',
                'color' => '#6c757d',
                'icon' => 'fas fa-cogs',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Notification',
                'slug' => 'notification',
                'description' => 'Notification and alert templates',
                'color' => '#ffc107',
                'icon' => 'fas fa-bell',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Marketing',
                'slug' => 'marketing',
                'description' => 'Marketing and promotional email templates',
                'color' => '#e83e8c',
                'icon' => 'fas fa-bullhorn',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Support',
                'slug' => 'support',
                'description' => 'Customer support and help templates',
                'color' => '#17a2b8',
                'icon' => 'fas fa-life-ring',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'Welcome and onboarding email templates',
                'color' => '#17a2b8',
                'icon' => 'fas fa-hand-wave',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Reminder',
                'slug' => 'reminder',
                'description' => 'Reminder and follow-up email templates',
                'color' => '#fd7e14',
                'icon' => 'fas fa-clock',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Promotional',
                'slug' => 'promotional',
                'description' => 'Promotional and marketing email templates',
                'color' => '#6f42c1',
                'icon' => 'fas fa-gift',
                'is_active' => true,
                'sort_order' => 10,
            ],
        ];

        foreach ($types as $type) {
            EmailTemplateType::firstOrCreate(
                ['slug' => $type['slug']],
                $type
            );
        }
    }
}