<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define all permissions
        $permissions = [
            // User Management Permissions
            'users.view',
            'users.create',
            'users.edit',
            'users.delete',
            
            // Role Management Permissions
            'roles.view',
            'roles.create',
            'roles.edit',
            'roles.delete',
            
            // Permission Management Permissions
            'permissions.view',
            'permissions.create',
            'permissions.edit',
            'permissions.delete',
            'permissions.assign',
            
            // Dashboard Permissions
            'dashboard.admin',
            'dashboard.specialist',
            'dashboard.officer',
            'dashboard.student',
            
            // Student Management Permissions
            'students.view',
            'students.create',
            'students.edit',
            'students.delete',
            
            // Course Management Permissions
            'courses.view',
            'courses.create',
            'courses.edit',
            'courses.delete',
            
            // Enrollment Permissions
            'enrollments.view',
            'enrollments.create',
            'enrollments.edit',
            'enrollments.delete',
            
            // Reports Permissions
            'reports.view',
            'reports.create',
            'reports.export',
            
            // Settings Permissions
            'settings.view',
            'settings.edit',
            
            // Resources Management Permissions
            'resources.view',
            'resources.create',
            'resources.edit',
            'resources.delete',
            
            // Learner Form Management Permissions
            'learners.view',
            'learners.create',
            'learners.edit',
            'learners.delete',
            
            // Quiz Management Permissions
            'quizzes.view',
            'quizzes.create',
            'quizzes.edit',
            'quizzes.delete',
            'quizzes.publish',
            'quizzes.analytics',
            'quizzes.invite',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign permissions to roles
        $this->assignPermissionsToRoles();
    }

    /**
     * Assign permissions to roles
     */
    private function assignPermissionsToRoles(): void
    {
        // Owner - All permissions
        $ownerRole = Role::where('name', 'Owner')->first();
        if ($ownerRole) {
            $ownerRole->givePermissionTo(Permission::all());
        }

        // Administrator - Most permissions except owner-specific
        $adminRole = Role::where('name', 'Administrator')->first();
        if ($adminRole) {
            $adminPermissions = [
                'users.view', 'users.create', 'users.edit', 'users.delete',
                'roles.view', 'roles.create', 'roles.edit', 'roles.delete',
                'permissions.view', 'permissions.create', 'permissions.edit', 'permissions.delete', 'permissions.assign',
                'dashboard.admin',
                'students.view', 'students.create', 'students.edit', 'students.delete',
                'courses.view', 'courses.create', 'courses.edit', 'courses.delete',
                'enrollments.view', 'enrollments.create', 'enrollments.edit', 'enrollments.delete',
                'reports.view', 'reports.create', 'reports.export',
                'settings.view', 'settings.edit',
                'resources.view', 'resources.create', 'resources.edit', 'resources.delete',
                'learners.view', 'learners.create', 'learners.edit', 'learners.delete',
                'quizzes.view', 'quizzes.create', 'quizzes.edit', 'quizzes.delete', 'quizzes.publish', 'quizzes.analytics', 'quizzes.invite',
            ];
            $adminRole->givePermissionTo($adminPermissions);
        }

        // LLN Specialist - Specialist permissions
        $specialistRole = Role::where('name', 'LLN Specialist')->first();
        if ($specialistRole) {
            $specialistPermissions = [
                'dashboard.specialist',
                'students.view', 'students.create', 'students.edit',
                'courses.view', 'courses.create', 'courses.edit',
                'enrollments.view', 'enrollments.create', 'enrollments.edit',
                'reports.view',
                'quizzes.view', 'quizzes.create', 'quizzes.edit', 'quizzes.analytics', 'quizzes.invite',
            ];
            $specialistRole->givePermissionTo($specialistPermissions);
        }

        // Enrolment Officer - Officer permissions
        $officerRole = Role::where('name', 'Enrolment Officer')->first();
        if ($officerRole) {
            $officerPermissions = [
                'dashboard.officer',
                'students.view', 'students.create', 'students.edit',
                'enrollments.view', 'enrollments.create', 'enrollments.edit',
                'reports.view',
            ];
            $officerRole->givePermissionTo($officerPermissions);
        }

        // Email Templates permissions
        $emailTemplatePermissions = [
            'email-templates.view',
            'email-templates.create',
            'email-templates.edit',
            'email-templates.delete',
        ];
        
        foreach ($emailTemplatePermissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'web',
            ]);
        }

        // Email Template Types permissions
        $emailTemplateTypePermissions = [
            'email-template-types.view',
            'email-template-types.create',
            'email-template-types.edit',
            'email-template-types.delete',
        ];
        
        foreach ($emailTemplateTypePermissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'web',
            ]);
        }

        // Owner - Email Templates permissions (Owner already has all permissions)
        // Administrator - Email Templates permissions
        $adminRole = Role::where('name', 'Administrator')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo($emailTemplatePermissions);
            $adminRole->givePermissionTo($emailTemplateTypePermissions);
        }

        // LLN Specialist - Email Templates permissions (view only)
        $llnRole = Role::where('name', 'LLN Specialist')->first();
        if ($llnRole) {
            $llnRole->givePermissionTo(['email-templates.view', 'email-template-types.view']);
        }

        // Student - Student permissions
        $studentRole = Role::where('name', 'Student')->first();
        if ($studentRole) {
            $studentPermissions = [
                'dashboard.student',
                'courses.view',
                'enrollments.view',
            ];
            $studentRole->givePermissionTo($studentPermissions);
        }
    }
}
