<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $defaultSettings = [
            [
                'key' => 'site_name',
                'value' => 'LLN Project',
                'type' => 'string',
                'description' => 'Site name',
            ],
            [
                'key' => 'site_email',
                'value' => 'admin@llnproject.com',
                'type' => 'string',
                'description' => 'Site email address',
            ],
            [
                'key' => 'site_phone',
                'value' => '',
                'type' => 'string',
                'description' => 'Site phone number',
            ],
            [
                'key' => 'site_address',
                'value' => '',
                'type' => 'string',
                'description' => 'Site address',
            ],
            [
                'key' => 'company_name',
                'value' => 'Skills Australia Institute',
                'type' => 'string',
                'description' => 'Company name',
            ],
            [
                'key' => 'learner_correspondence_name',
                'value' => 'Skills Australia Institute',
                'type' => 'string',
                'description' => 'Learner correspondence name',
            ],
            [
                'key' => 'learner_correspondence_phone',
                'value' => '+61 410001429',
                'type' => 'string',
                'description' => 'Learner correspondence phone',
            ],
            [
                'key' => 'learner_correspondence_email',
                'value' => 'admissions@skillsaustralia.edu.au',
                'type' => 'string',
                'description' => 'Learner correspondence email',
            ],
            [
                'key' => 'learner_redirection_url',
                'value' => 'http://www.skillsaustralia.edu.au',
                'type' => 'string',
                'description' => 'Learner redirection URL',
            ],
            [
                'key' => 'admin_correspondence_name',
                'value' => 'Skills Australia Institute',
                'type' => 'string',
                'description' => 'Admin correspondence name',
            ],
            [
                'key' => 'admin_correspondence_email',
                'value' => 'admissions@skillsaustralia.edu.au',
                'type' => 'string',
                'description' => 'Admin correspondence email',
            ],
            [
                'key' => 'daily_summary_quiz_completion_email',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Daily summary quiz completion email',
            ],
            [
                'key' => 'daily_summary_email_contact',
                'value' => 'default admin correspondence',
                'type' => 'string',
                'description' => 'Daily summary email contact',
            ],
            [
                'key' => 'immediate_quiz_completion_emails',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Immediate quiz completion emails',
            ],
            [
                'key' => 'immediate_completion_email_contact',
                'value' => 'default admin correspondence',
                'type' => 'string',
                'description' => 'Immediate completion email contact',
            ],
            [
                'key' => 'deleted_learner_notifications',
                'value' => '0',
                'type' => 'boolean',
                'description' => 'Deleted learner notifications',
            ],
            [
                'key' => 'incomplete_reminders_to_learners',
                'value' => '0',
                'type' => 'boolean',
                'description' => 'Incomplete reminders to learners',
            ],
            [
                'key' => 'learner_pre_enrolment_report',
                'value' => '0',
                'type' => 'boolean',
                'description' => 'Learner pre-enrolment report',
            ],
            [
                'key' => 'quiz_reminder_days',
                'value' => '7',
                'type' => 'integer',
                'description' => 'Days to send quiz reminders',
            ],
            [
                'key' => 'quiz_reminder_gap_days',
                'value' => '3',
                'type' => 'integer',
                'description' => 'Gap between quiz reminders in days',
            ],
            [
                'key' => 'copyright_text',
                'value' => '© 2024 LLN Project. All rights reserved.',
                'type' => 'string',
                'description' => 'Copyright text',
            ],
            [
                'key' => 'site_logo',
                'value' => '',
                'type' => 'string',
                'description' => 'Site logo',
            ],
            [
                'key' => 'maintenance_mode',
                'value' => '0',
                'type' => 'boolean',
                'description' => 'Maintenance mode',
            ],
            [
                'key' => 'user_registration',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Allow user registration',
            ],
            [
                'key' => 'email_notifications',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Email notifications',
            ],
            [
                'key' => 'session_timeout',
                'value' => '120',
                'type' => 'integer',
                'description' => 'Session timeout in minutes',
            ],
            [
                'key' => 'max_login_attempts',
                'value' => '5',
                'type' => 'integer',
                'description' => 'Maximum login attempts',
            ],
            [
                'key' => 'password_min_length',
                'value' => '8',
                'type' => 'integer',
                'description' => 'Minimum password length',
            ],
            [
                'key' => 'require_password_confirmation',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Require password confirmation',
            ],
        ];

        foreach ($defaultSettings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}