<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="LLN Quiz Portal - Student Learning Platform">
    <meta name="author" content="LLN Project">
    <meta name="keywords" content="quiz, learning, education, student, portal, lln">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}" />
    
    <title>Login - {{ \App\Models\Setting::get('site_name', config('app.name', 'LLN Quiz Portal')) }}</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="{{ asset('css/auth.css') }}" rel="stylesheet">

    @livewireStyles
</head>

<body>
    <div class="auth-container">
        <!-- Floating Elements -->
        <div class="floating-elements">
            <div class="floating-element"></div>
            <div class="floating-element"></div>
            <div class="floating-element"></div>
        </div>

        <div class="auth-card">
            <!-- Auth Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    @php
                        $logoPath = \App\Models\Setting::get('site_logo');
                        $logoUrl = $logoPath ? \Storage::url($logoPath) : null;
                    @endphp
                    @if($logoUrl && \Storage::disk('public')->exists($logoPath))
                        <img src="{{ $logoUrl }}" alt="{{ \App\Models\Setting::get('site_name', config('app.name')) }} Logo" class="img-fluid">
                    @else
                        <div class="default-logo">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                    @endif
                </div>
                <h1 class="auth-title">Welcome Back!</h1>
                <p class="auth-subtitle">Sign in to your account to continue learning</p>
            </div>

            <!-- Auth Body -->
            <div class="auth-body">
                <!-- Status / flash messages -->
                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle"></i>
                        {{ session('status') }}
                    </div>
                @endif

                <!-- Error messages -->
                @if (session('error'))
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle"></i>
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Validation errors -->
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle"></i>
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif

                <!-- Login Form -->
                <form method="POST" action="{{ route('login') }}" id="loginForm">
                    @csrf

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="email">
                                <i class="fas fa-envelope me-1"></i>
                                Email Address
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <input
                                id="email"
                                class="form-control @error('email') is-invalid @enderror"
                                type="email"
                                name="email"
                                placeholder="Enter your email address"
                                value="{{ old('email') }}"
                                required
                                autofocus
                            />
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="password">
                                <i class="fas fa-lock me-1"></i>
                                Password
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <div class="input-group">
                                <input
                                    id="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    type="password"
                                    name="password"
                                    placeholder="Enter your password"
                                    required
                                    autocomplete="current-password"
                                />
                                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-check mb-4">
                        <input id="remember" type="checkbox" class="form-check-input" name="remember">
                        <label class="form-check-label" for="remember">
                            Remember me for 30 days
                        </label>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn-auth btn-primary-auth" id="loginBtn">
                            <i class="fas fa-sign-in-alt me-2"></i>
                            Sign In
                        </button>
                    </div>
                </form>
            </div>

            <!-- Auth Footer -->
            <div class="auth-footer">
                <div class="auth-footer-text">
                    Don't have an account?
                    <a href="{{ route('register') }}" class="auth-link">Create one here</a>
                </div>
                <div class="auth-footer-text">
                    <a href="{{ route('password.request') }}" class="auth-link">Forgot your password?</a>
                </div>
                <p class="auth-copyright">
                    {{ \App\Models\Setting::get('copyright_text', '© ' . date('Y') . ' LLN Quiz Portal. All rights reserved.') }}
                </p>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- JavaScript -->
    <script>
        // Form submission with loading state
        document.getElementById('loginForm').addEventListener('submit', function() {
            const btn = document.getElementById('loginBtn');
            btn.classList.add('loading');
            btn.disabled = true;
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s ease';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);

        // Password toggle functionality
        function setupPasswordToggle(toggleId, inputId) {
            const toggleBtn = document.getElementById(toggleId);
            const passwordInput = document.getElementById(inputId);
            
            if (toggleBtn && passwordInput) {
                toggleBtn.addEventListener('click', function() {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    
                    const icon = toggleBtn.querySelector('i');
                    icon.classList.toggle('fa-eye');
                    icon.classList.toggle('fa-eye-slash');
                });
            }
        }

        // Setup password toggle
        setupPasswordToggle('togglePassword', 'password');

        // Add focus effects to form controls
        const formControls = document.querySelectorAll('.form-control');
        formControls.forEach(function(control) {
            control.addEventListener('focus', function() {
                this.parentElement.classList.add('focused');
            });
            
            control.addEventListener('blur', function() {
                if (!this.value) {
                    this.parentElement.classList.remove('focused');
                }
            });
        });
    </script>

    @livewireScripts
</body>
</html>