<nav id="sidebar" class="sidebar js-sidebar">
    <div class="sidebar-content js-simplebar">
    <a class="sidebar-brand d-flex align-items-center justify-content-center p-3 mb-3 border-bottom sidebar-brand-container" href="{{ url('/admin/dashboard') }}">
        @php
            $siteLogo = \App\Models\Setting::get('site_logo', '');
            $siteName = \App\Models\Setting::get('site_name', 'LLN Project');
        @endphp
        
        @if($siteLogo && \Storage::disk('public')->exists($siteLogo))
            <img src="{{ asset('storage/' . $siteLogo) }}" 
                 alt="{{ $siteName }}" 
                 class="img-fluid sidebar-logo">
        @else
            <span class="align-middle fw-semibold text-center text-truncate">{{ $siteName }}</span>
        @endif
    </a>

        <ul class="sidebar-nav">
            <li class="sidebar-header">
             Pages
            </li>

            @auth
                @if(auth()->user()->hasRole('Owner') || auth()->user()->hasRole('Administrator'))
                    <li class="sidebar-item {{ request()->is('admin/dashboard') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/dashboard') }}">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Dashboard</span>
                      </a>
                    </li>

                    @can('users.view')
                    <li class="sidebar-item {{ request()->is('admin/users*') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/users') }}">
                        <i class="align-middle" data-feather="users"></i> <span class="align-middle">Manage Users</span>
                      </a>
                    </li>
                    @endcan

                    @can('roles.view')
                    <li class="sidebar-item {{ request()->is('admin/roles*') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/roles') }}">
                        <i class="align-middle" data-feather="user-check"></i> <span class="align-middle">Manage Roles</span>
                      </a>
                    </li>
                    @endcan

                    @can('quizzes.view')
                    <li class="sidebar-item {{ request()->is('admin/quizzes*') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/quizzes') }}">
                        <i class="align-middle" data-feather="clipboard"></i> <span class="align-middle">Quiz Management</span>
                      </a>
                    </li>
                    @endcan

                    @can('resources.view')
                    <li class="sidebar-item {{ request()->is('admin/resources*') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/resources') }}">
                        <i class="align-middle" data-feather="folder"></i> <span class="align-middle">Resources</span>
                      </a>
                    </li>
                    @endcan

                    @can('learners.view')
                    <li class="sidebar-item {{ request()->is('admin/learner-forms*') || request()->is('admin/learners*') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/admin/learner-forms') }}">
                        <i class="align-middle" data-feather="users"></i> <span class="align-middle">Manage Learner Form</span>
                      </a>
                    </li>
                    @endcan

        @canany(['email-templates.view', 'email-template-types.view'])
        <li class="sidebar-item {{ request()->is('admin/email-templates*') || request()->is('admin/email-template-types*') ? 'active' : '' }}">
          <a class="sidebar-link" href="#" onclick="toggleEmailMenu(event)">
            <i class="align-middle" data-feather="mail"></i> <span class="align-middle">Email Templates</span>
            <i class="align-middle ms-auto" data-feather="chevron-down" id="emailMenuIcon"></i>
          </a>
          <ul class="sidebar-dropdown list-unstyled {{ request()->is('admin/email-templates*') || request()->is('admin/email-template-types*') ? 'show' : '' }}" id="emailMenu">
            @can('email-templates.view')
            <li class="sidebar-item {{ request()->is('admin/email-templates*') && !request()->is('admin/email-template-types*') ? 'active' : '' }}">
              <a class="sidebar-link" href="{{ url('/admin/email-templates') }}">
                <i class="align-middle" data-feather="file-text"></i> <span class="align-middle">Templates</span>
              </a>
            </li>
            @endcan
            
            @can('email-template-types.view')
            <li class="sidebar-item {{ request()->is('admin/email-template-types*') ? 'active' : '' }}">
              <a class="sidebar-link" href="{{ url('/admin/email-template-types') }}">
                <i class="align-middle" data-feather="tag"></i> <span class="align-middle">Template Types</span>
              </a>
            </li>
            @endcan
          </ul>
        </li>
        @endcanany

                    @if(auth()->user()->hasRole('Owner'))
                    <li class="sidebar-header">
                      <span class="align-middle">Owner Settings</span>
                    </li>


               @can('settings.view')
               <li class="sidebar-item {{ request()->is('admin/email-settings*') ? 'active' : '' }}">
                 <a class="sidebar-link" href="{{ url('/admin/email-settings') }}">
                   <i class="align-middle" data-feather="mail"></i> <span class="align-middle">Email Settings</span>
                 </a>
               </li>
               @endcan

               @can('settings.view')
               <li class="sidebar-item {{ request()->is('admin/settings*') ? 'active' : '' }}">
                 <a class="sidebar-link" href="{{ url('/admin/settings') }}">
                   <i class="align-middle" data-feather="settings"></i> <span class="align-middle">Settings & Privacy</span>
                 </a>
               </li>
               @endcan
                    @endif
                @elseif(auth()->user()->hasRole('LLN Specialist'))
                    <li class="sidebar-item {{ request()->is('specialist/dashboard') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/specialist/dashboard') }}">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Specialist Dashboard</span>
                      </a>
                    </li>
                @elseif(auth()->user()->hasRole('Enrolment Officer'))
                    <li class="sidebar-item {{ request()->is('officer/dashboard') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/officer/dashboard') }}">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Officer Dashboard</span>
                      </a>
                    </li>
                @elseif(auth()->user()->hasRole('Student'))
                    <li class="sidebar-item {{ request()->is('student/dashboard') ? 'active' : '' }}">
                      <a class="sidebar-link" href="{{ url('/student/dashboard') }}">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Student Dashboard</span>
                      </a>
                    </li>
                @endif
            @endauth
        </ul>
    </div>
</nav>

<script>
function toggleEmailMenu(event) {
    event.preventDefault();
    const menu = document.getElementById('emailMenu');
    const icon = document.getElementById('emailMenuIcon');
    
    if (menu.classList.contains('show')) {
        menu.classList.remove('show');
        icon.style.transform = 'rotate(0deg)';
    } else {
        menu.classList.add('show');
        icon.style.transform = 'rotate(180deg)';
    }
}
</script>
<!-- Sidebar !-->