@extends('Admin.layouts.layout')

@section('content')
    <div class="container-fluid px-4 py-3">
        <!-- Page Header -->
        <div class="page-header-two-row">
            <div class="page-title-row">
                <h1 class="page-title-two-row">
                    <i class="fas fa-envelope"></i>
                    Quiz Invitations
                </h1>
            </div>
            <div class="page-actions-row">
                <div class="breadcrumb-section">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.dashboard') }}">
                                    <i class="fas fa-home me-1"></i>Dashboard
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.quizzes') }}">
                                    <i class="fas fa-question-circle me-1"></i>Quizzes
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.quizzes.show', $quiz) }}">
                                    {{ $quiz->title }}
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                Invitations
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <!-- Livewire Component -->
        @livewire('admin.quiz-invitation-management', ['quiz' => $quiz])
    </div>
@endsection


