<!-- Include Modal CSS -->
<link href="{{ url('/admin/css/modal.css') }}" rel="stylesheet">

<!-- Beautiful Delete Question Confirmation Modal -->
<div id="deleteQuestionModal" class="beautiful-modal" style="display: none;">
    <div class="beautiful-modal-backdrop"></div>
    <div class="beautiful-modal-dialog">
        <div class="beautiful-modal-content">
            <!-- Header with gradient and icon -->
            <div class="beautiful-modal-header">
                <div class="beautiful-modal-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="beautiful-modal-title-section">
                    <h4 class="beautiful-modal-title">Delete Question</h4>
                    <p class="beautiful-modal-subtitle">This action cannot be undone</p>
                </div>
                <button type="button" class="beautiful-modal-close" onclick="hideDeleteQuestionModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <!-- Body with beautiful content -->
            <div class="beautiful-modal-body">
                <div class="beautiful-warning-box">
                    <div class="beautiful-warning-icon">
                        <i class="fas fa-question-circle"></i>
                    </div>
                    <div class="beautiful-warning-content">
                        <h6 class="beautiful-warning-title">Are you sure you want to delete this question?</h6>
                        <p class="beautiful-warning-text">This will permanently remove the question and all associated data.</p>
                    </div>
                </div>
                
                <div class="beautiful-question-preview">
                    <div class="beautiful-question-label">
                        <i class="fas fa-file-alt me-2"></i>Question Preview
                    </div>
                    <div class="beautiful-question-content">
                        <p id="deleteQuestionText" class="beautiful-question-text"></p>
                    </div>
                </div>
            </div>
            
            <!-- Footer with beautiful buttons -->
            <div class="beautiful-modal-footer">
                <button type="button" class="beautiful-btn beautiful-btn-secondary" onclick="hideDeleteQuestionModal()">
                    <i class="fas fa-arrow-left me-2"></i>
                    <span>Keep Question</span>
                </button>
                <button type="button" class="beautiful-btn beautiful-btn-danger" onclick="confirmDeleteQuestion()">
                    <i class="fas fa-trash me-2"></i>
                    <span>Delete Forever</span>
                </button>
            </div>
        </div>
    </div>
</div>


<script>
// Global modal functions for delete question
let questionIdToDelete = null;

function showDeleteQuestionModal(questionId, questionText) {
    questionIdToDelete = questionId;
    document.getElementById('deleteQuestionText').textContent = questionText;
    const modal = document.getElementById('deleteQuestionModal');
    modal.style.display = 'flex';
    modal.classList.add('show');
    document.body.style.overflow = 'hidden'; // Prevent background scrolling
}

function hideDeleteQuestionModal() {
    const modal = document.getElementById('deleteQuestionModal');
    modal.style.display = 'none';
    modal.classList.remove('show');
    document.body.style.overflow = 'auto'; // Restore scrolling
    questionIdToDelete = null;
    document.getElementById('deleteQuestionText').textContent = '';
}

function confirmDeleteQuestion() {
    if (questionIdToDelete) {
        // Use Livewire's dispatch method to trigger the delete
        if (window.Livewire) {
            window.Livewire.dispatch('deleteQuestion', { questionId: questionIdToDelete });
        }
        hideDeleteQuestionModal();
    }
}

// Close modal when clicking backdrop
document.addEventListener('click', function(event) {
    const modal = document.getElementById('deleteQuestionModal');
    if (event.target === modal || event.target.classList.contains('beautiful-modal-backdrop')) {
        hideDeleteQuestionModal();
    }
});

// Close modal with Escape key
document.addEventListener('keydown', function(event) {
    if (event.key === 'Escape') {
        hideDeleteQuestionModal();
    }
});
</script>
