<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Email - {{ $emailData['siteName'] }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .email-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .email-body {
            padding: 30px;
        }
        .test-message {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 0 8px 8px 0;
        }
        .email-footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }
        .timestamp {
            color: #6c757d;
            font-size: 14px;
            margin-top: 20px;
        }
        .success-icon {
            font-size: 48px;
            color: #28a745;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <div class="success-icon">✅</div>
            <h1>Email Test Successful</h1>
            <p>{{ $emailData['siteName'] }} - Email System Working</p>
        </div>
        
        <div class="email-body">
            <h2>Test Email Confirmation</h2>
            <p>This is a test email to verify that your email notification system is working correctly.</p>
            
            <div class="test-message">
                <h3>Test Message:</h3>
                <p>{{ $emailData['message'] }}</p>
            </div>
            
            <h3>System Status:</h3>
            <ul>
                <li>✅ Email notifications are enabled</li>
                <li>✅ Email service is working correctly</li>
                <li>✅ SMTP configuration is valid</li>
                <li>✅ Email template is rendering properly</li>
            </ul>
            
            <div class="timestamp">
                <strong>Sent at:</strong> {{ $emailData['timestamp'] }}
            </div>
        </div>
        
        <div class="email-footer">
            <p><strong>{{ $emailData['siteName'] }}</strong></p>
            <p>This is an automated test email from your system.</p>
            <p style="color: #6c757d; font-size: 12px;">
                If you received this email, your email notification system is working correctly.
            </p>
        </div>
    </div>
</body>
</html>

