<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-envelope"></i>
                Email Settings
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-envelope me-1"></i>Email Settings
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- SMTP Configuration -->
            <div class="card mb-4">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-server me-2"></i>SMTP Configuration
                        </h5>
                        <button type="button" class="btn btn-outline-secondary btn-sm" wire:click="refreshSettings">
                            <i class="fas fa-sync-alt me-1"></i>Refresh from .env
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-4">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>SMTP Settings:</strong> Configure your email server settings. These settings will be saved to your .env file.
                        <br><small class="text-muted">Current values are loaded from your .env file.</small>
                    </div>
                    
                    <form wire:submit.prevent="updateSmtpSettings">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_mailer" class="form-label">Mail Driver *</label>
                                    <input type="text" 
                                           class="form-control @error('smtpSettings.MAIL_MAILER') is-invalid @enderror" 
                                           id="mail_mailer" 
                                           wire:model="smtpSettings.MAIL_MAILER"
                                           placeholder="smtp">
                                    @error('smtpSettings.MAIL_MAILER') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    <small class="text-muted">Common values: smtp, mailgun, ses, postmark</small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_host" class="form-label">SMTP Host *</label>
                                    <input type="text" 
                                           class="form-control @error('smtpSettings.MAIL_HOST') is-invalid @enderror" 
                                           id="mail_host" 
                                           wire:model="smtpSettings.MAIL_HOST"
                                           placeholder="smtp.gmail.com">
                                    @error('smtpSettings.MAIL_HOST') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_port" class="form-label">SMTP Port *</label>
                                    <input type="number" 
                                           class="form-control @error('smtpSettings.MAIL_PORT') is-invalid @enderror" 
                                           id="mail_port" 
                                           wire:model="smtpSettings.MAIL_PORT"
                                           placeholder="587">
                                    @error('smtpSettings.MAIL_PORT') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_encryption" class="form-label">Encryption *</label>
                                    <select class="form-select @error('smtpSettings.MAIL_ENCRYPTION') is-invalid @enderror" 
                                            id="mail_encryption" 
                                            wire:model="smtpSettings.MAIL_ENCRYPTION">
                                        <option value="">Select Encryption</option>
                                        <option value="tls">TLS</option>
                                        <option value="ssl">SSL</option>
                                        <option value="">None</option>
                                    </select>
                                    @error('smtpSettings.MAIL_ENCRYPTION') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_username" class="form-label">SMTP Username *</label>
                                    <input type="text" 
                                           class="form-control @error('smtpSettings.MAIL_USERNAME') is-invalid @enderror" 
                                           id="mail_username" 
                                           wire:model="smtpSettings.MAIL_USERNAME"
                                           placeholder="your-email@gmail.com">
                                    @error('smtpSettings.MAIL_USERNAME') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_password" class="form-label">SMTP Password *</label>
                                    <input type="password" 
                                           class="form-control @error('smtpSettings.MAIL_PASSWORD') is-invalid @enderror" 
                                           id="mail_password" 
                                           wire:model="smtpSettings.MAIL_PASSWORD"
                                           placeholder="Your email password or app password">
                                    @error('smtpSettings.MAIL_PASSWORD') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_from_address" class="form-label">From Email Address *</label>
                                    <input type="email" 
                                           class="form-control @error('smtpSettings.MAIL_FROM_ADDRESS') is-invalid @enderror" 
                                           id="mail_from_address" 
                                           wire:model="smtpSettings.MAIL_FROM_ADDRESS"
                                           placeholder="noreply@yourdomain.com">
                                    @error('smtpSettings.MAIL_FROM_ADDRESS') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mail_from_name" class="form-label">From Name *</label>
                                    <input type="text" 
                                           class="form-control @error('smtpSettings.MAIL_FROM_NAME') is-invalid @enderror" 
                                           id="mail_from_name" 
                                           wire:model="smtpSettings.MAIL_FROM_NAME"
                                           placeholder="Your Application Name">
                                    @error('smtpSettings.MAIL_FROM_NAME') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="updateSmtpSettings">
                                    <i class="fas fa-save me-2"></i>Save SMTP Settings
                                </span>
                                <span wire:loading wire:target="updateSmtpSettings">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Saving...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Email Testing -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-paper-plane me-2"></i>Email Testing
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-4">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Test Email Functionality:</strong> Use this section to test if email notifications are working correctly. 
                        The email will only be sent if "Email Notifications" is enabled in System Settings.
                    </div>
                    
                    <form wire:submit.prevent="sendTestEmail">
                        <div class="row g-4">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="testEmail" class="form-label">Test Email Address *</label>
                                    <input type="email" 
                                           class="form-control @error('testEmail') is-invalid @enderror" 
                                           id="testEmail" 
                                           wire:model="testEmail"
                                           placeholder="Enter email address to send test email">
                                    @error('testEmail') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="testEmailSubject" class="form-label">Email Subject *</label>
                                    <input type="text" 
                                           class="form-control @error('testEmailSubject') is-invalid @enderror" 
                                           id="testEmailSubject" 
                                           wire:model="testEmailSubject">
                                    @error('testEmailSubject') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="testEmailMessage" class="form-label">Test Message *</label>
                                    <textarea class="form-control @error('testEmailMessage') is-invalid @enderror" 
                                              id="testEmailMessage" 
                                              wire:model="testEmailMessage" 
                                              rows="4"></textarea>
                                    @error('testEmailMessage') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <div class="mb-3">
                                    <button type="submit" class="btn btn-success" wire:loading.attr="disabled">
                                        <span wire:loading.remove wire:target="sendTestEmail">
                                            <i class="fas fa-paper-plane me-2"></i>Send Test Email
                                        </span>
                                        <span wire:loading wire:target="sendTestEmail">
                                            <i class="fas fa-spinner fa-spin me-2"></i>Sending...
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-3">
                            <small class="text-muted">
                                <i class="fas fa-lightbulb me-1"></i>
                                <strong>Tip:</strong> Check your email inbox after sending. If you don't receive the email, 
                                verify your SMTP settings above and ensure "Email Notifications" is enabled in System Settings.
                            </small>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Email Information -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Email Configuration Help
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="fw-bold">Gmail Configuration</h6>
                        <ul class="text-muted small">
                            <li>Host: smtp.gmail.com</li>
                            <li>Port: 587</li>
                            <li>Encryption: TLS</li>
                            <li>Use App Password for authentication</li>
                        </ul>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="fw-bold">Outlook Configuration</h6>
                        <ul class="text-muted small">
                            <li>Host: smtp-mail.outlook.com</li>
                            <li>Port: 587</li>
                            <li>Encryption: TLS</li>
                        </ul>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="fw-bold">Yahoo Configuration</h6>
                        <ul class="text-muted small">
                            <li>Host: smtp.mail.yahoo.com</li>
                            <li>Port: 587</li>
                            <li>Encryption: TLS</li>
                        </ul>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="fw-bold">Custom SMTP</h6>
                        <ul class="text-muted small">
                            <li>Contact your hosting provider</li>
                            <li>Get SMTP credentials</li>
                            <li>Use appropriate port and encryption</li>
                        </ul>
</div>

                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Security Note:</strong> SMTP settings are saved to your .env file. Make sure to keep your email credentials secure.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>