<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-envelope"></i>
                Email Templates Management
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#" onclick="toggleEmailMenu(event)">
                                <i class="fas fa-envelope me-1"></i>Email Templates
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-file-text me-1"></i>Templates
                        </li>
                    </nav>
                </ol>
            </div>
            <div class="action-section">
                @can('email-templates.create')
                <a href="{{ route('admin.email-templates.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Template
                </a>
                @endcan
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search templates..." wire:model.live="search">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" wire:model.live="typeFilter">
                                <option value="">All Types</option>
                                @foreach($typeOptions as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Status</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex gap-2">
                                @if($search || $typeFilter || $statusFilter !== '')
                                    <button type="button" class="btn btn-outline-secondary btn-sm" wire:click="clearFilters">
                                        <i class="fas fa-times me-1"></i>Clear
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Templates Table -->
                    <div class="table-responsive d-none d-lg-block">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th wire:click="sortBy('name')" class="sortable">
                                        Template Name
                                        @if($sortField === 'name')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th>Subject</th>
                                    <th>Type</th>
                                    <th wire:click="sortBy('is_active')" class="sortable">
                                        Status
                                        @if($sortField === 'is_active')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th wire:click="sortBy('created_at')" class="sortable">
                                        Created
                                        @if($sortField === 'created_at')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($templates as $template)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="template-icon me-3">
                                                    @switch($template->type)
                                                        @case('learner')
                                                            <i class="fas fa-user-graduate text-info"></i>
                                                            @break
                                                        @case('admin')
                                                            <i class="fas fa-user-shield text-primary"></i>
                                                            @break
                                                        @case('system')
                                                            <i class="fas fa-cog text-warning"></i>
                                                            @break
                                                        @case('notification')
                                                            <i class="fas fa-bell text-success"></i>
                                                            @break
                                                        @default
                                                            <i class="fas fa-envelope text-secondary"></i>
                                                    @endswitch
                                                </div>
<div>
                                                    <div class="fw-bold">{{ $template->name }}</div>
                                                    @if($template->description)
                                                        <small class="text-muted">{{ Str::limit($template->description, 50) }}</small>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ Str::limit($template->subject, 50) }}</td>
                                        <td>
                                            <span class="badge bg-info">{{ $typeOptions[$template->type] ?? $template->type }}</span>
                                        </td>
                                        <td>
                                            @if($template->is_active)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-danger">Inactive</span>
                                            @endif
                                        </td>
                                        <td>{{ $template->created_at->format('M d, Y') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @can('email-templates.view')
                                                <button type="button" class="btn btn-sm btn-outline-info"
                                                        wire:click="previewTemplate({{ $template->id }})" title="Preview">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                @endcan
                                                @can('email-templates.edit')
                                                <a href="{{ route('admin.email-templates.edit', $template->id) }}"
                                                   class="btn btn-sm btn-outline-primary" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                @can('email-templates.edit')
                                                <button type="button" class="btn btn-sm {{ $template->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }}"
                                                        wire:click="toggleStatus({{ $template->id }})" title="{{ $template->is_active ? 'Deactivate' : 'Activate' }}">
                                                    <i class="fas fa-{{ $template->is_active ? 'pause' : 'play' }}"></i>
                                                </button>
                                                @endcan
                                                @can('email-templates.delete')
                                                <button type="button" class="btn btn-sm btn-outline-danger"
                                                        wire:click="deleteTemplate({{ $template->id }})"
                                                        wire:confirm="Are you sure you want to delete this template?"
                                                        title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-envelope fa-3x mb-3"></i>
                                                <p>No email templates found</p>
                                                @if($search || $typeFilter || $statusFilter !== '')
                                                    <p>Try adjusting your search criteria</p>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($templates->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            {{ $templates->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Card View -->
    @if($templates->count() > 0)
        <div class="d-lg-none">
            @foreach($templates as $template)
                <div class="card mb-3">
                    <div class="card-body p-3">
                        <div class="row align-items-start mb-3">
                            <div class="col-auto">
                                @switch($template->type)
                                    @case('learner')
                                        <i class="fas fa-user-graduate text-info fa-2x"></i>
                                        @break
                                    @case('admin')
                                        <i class="fas fa-user-shield text-primary fa-2x"></i>
                                        @break
                                    @case('system')
                                        <i class="fas fa-cog text-warning fa-2x"></i>
                                        @break
                                    @case('notification')
                                        <i class="fas fa-bell text-success fa-2x"></i>
                                        @break
                                    @default
                                        <i class="fas fa-envelope text-secondary fa-2x"></i>
                                @endswitch
                            </div>
                            <div class="col">
                                <h6 class="card-title mb-1 fw-semibold">{{ $template->name }}</h6>
                                <p class="text-muted small mb-1">{{ Str::limit($template->subject, 60) }}</p>
                                <div class="d-flex flex-wrap gap-2 mb-2">
                                    <span class="badge bg-info">{{ $typeOptions[$template->type] ?? $template->type }}</span>
                                    @if($template->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </div>
                                <small class="text-muted">Created: {{ $template->created_at->format('M d, Y') }}</small>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="row g-2">
                            @can('email-templates.view')
                            <div class="col-4">
                                <button type="button" class="btn btn-sm btn-outline-info w-100"
                                        wire:click="previewTemplate({{ $template->id }})">
                                    <i class="fas fa-eye me-1"></i>View
                                </button>
                            </div>
                            @endcan
                            @can('email-templates.edit')
                            <div class="col-4">
                                <a href="{{ route('admin.email-templates.edit', $template->id) }}"
                                   class="btn btn-sm btn-outline-primary w-100">
                                    <i class="fas fa-edit me-1"></i>Edit
                                </a>
                            </div>
                            @endcan
                            @can('email-templates.edit')
                            <div class="col-4">
                                <button type="button" class="btn btn-sm {{ $template->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }} w-100"
                                        wire:click="toggleStatus({{ $template->id }})">
                                    <i class="fas fa-{{ $template->is_active ? 'pause' : 'play' }} me-1"></i>
                                    {{ $template->is_active ? 'Deactivate' : 'Activate' }}
                                </button>
                            </div>
                            @endcan
                            @can('email-templates.delete')
                            <div class="col-12">
                                <button type="button" class="btn btn-sm btn-outline-danger w-100"
                                        wire:click="deleteTemplate({{ $template->id }})"
                                        wire:confirm="Are you sure you want to delete this template?">
                                    <i class="fas fa-trash me-1"></i>Delete
                                </button>
                            </div>
                            @endcan
                        </div>
                    </div>
                </div>
            @endforeach

            <!-- Mobile Pagination -->
            @if($templates->hasPages())
                <div class="d-flex justify-content-center mt-4">
                    {{ $templates->links() }}
                </div>
            @endif
        </div>
    @endif

    <!-- Preview Modal -->
    @if($showPreviewModal)
    <div class="modal-backdrop fade show" style="z-index: 1050; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.6);"></div>
    <div class="modal fade show d-block" tabindex="-1" style="z-index: 1055; position: fixed; top: 0; left: 0; width: 100%; height: 100%; overflow: auto; background-color: transparent;">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-eye me-2"></i>Email Template Preview
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal"></button>
                </div>
                <div class="modal-body p-3">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-primary">
                                    <i class="fas fa-envelope me-1"></i>Email Subject:
                                </label>
                                <div class="email-preview-subject">
                                    {{ $previewSubject }}
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label fw-bold text-primary">
                                <i class="fas fa-align-left me-1"></i>Email Body:
                            </label>
                            <div class="email-preview-body">
                                {!! $previewBody !!}
                            </div>
                        </div>
</div>

                    <div class="mt-3">
                        <div class="alert alert-info border-0 shadow-sm">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Preview Note:</strong> This is a preview with sample data. Variables are replaced with example values to show how the email will appear when sent to actual users.
                        </div>
                        
                        @if(!empty($templateTypeStatus))
                        <div class="alert {{ $templateTypeStatus['active'] ? 'alert-success' : 'alert-warning' }} border-0 shadow-sm mt-3">
                            <i class="fas fa-{{ $templateTypeStatus['active'] ? 'check-circle' : 'exclamation-triangle' }} me-2"></i>
                            <strong>Template Type Status:</strong> 
                            {{ $templateTypeStatus['message'] }}
                            @if(isset($templateTypeStatus['type_name']))
                                <br><small class="text-muted">Type: {{ $templateTypeStatus['type_name'] }}</small>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer bg-light border-top">
                    <button type="button" class="btn btn-secondary" wire:click="closePreviewModal">
                        <i class="fas fa-times me-2"></i>Close Preview
                    </button>
                    @if($previewTemplateData)
                    <a href="{{ route('admin.email-templates.edit', $previewTemplateData->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Template
                    </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif
</div>