<div>
<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit Email Template Type' : 'Create Email Template Type' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#" onclick="toggleEmailMenu(event)">
                                <i class="fas fa-envelope me-1"></i>Email Templates
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.email-template-types') }}">
                                <i class="fas fa-tag me-1"></i>Template Types
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-1"></i>
                            {{ $editMode ? 'Edit Type' : 'Create Type' }}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <a href="{{ route('admin.email-template-types') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Types
                </a>
            </div>
        </div>
    </div>

    <form wire:submit.prevent="save">
        <div class="row">
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2"></i>Basic Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label">Type Name <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('name') is-invalid @enderror"
                                       id="name"
                                       wire:model="name"
                                       placeholder="Enter type name"
                                       required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="slug" class="form-label">Slug <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('slug') is-invalid @enderror"
                                       id="slug"
                                       wire:model="slug"
                                       placeholder="auto-generated-slug"
                                       required>
                                @error('slug')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          id="description"
                                          wire:model="description"
                                          rows="5"
                                          placeholder="Enter type description"></textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Appearance Settings -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-palette me-2"></i>Appearance Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="color" class="form-label">Color <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="color" 
                                           class="form-control form-control-color @error('color') is-invalid @enderror"
                                           id="color"
                                           wire:model="color"
                                           title="Choose color">
                                    <input type="text" 
                                           class="form-control @error('color') is-invalid @enderror"
                                           wire:model="color"
                                           placeholder="#007bff">
                                </div>
                                @error('color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="icon" class="form-label">Icon</label>
                                <input type="text" 
                                       class="form-control @error('icon') is-invalid @enderror"
                                       id="icon"
                                       wire:model="icon"
                                       placeholder="fas fa-envelope">
                                <small class="form-text text-muted">Font Awesome icon class (e.g., fas fa-envelope)</small>
                                @error('icon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <!-- Settings -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-cog me-2"></i>Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label for="sort_order" class="form-label">Sort Order <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror"
                                       id="sort_order"
                                       wire:model="sort_order"
                                       min="0"
                                       placeholder="0">
                                <small class="form-text text-muted">Lower numbers appear first</small>
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
</div>

                            <div class="col-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="is_active"
                                           wire:model="is_active">
                                    <label class="form-check-label" for="is_active">
                                        Active Type
                                    </label>
                                </div>
                                <small class="form-text text-muted">Inactive types won't be available for selection</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Preview -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-eye me-2"></i>Preview
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="type-preview">
                            <div class="d-flex align-items-center">
                                <div class="type-color-indicator me-3" style="background-color: {{ $color }};"></div>
                                <div>
                                    <div class="fw-semibold">{{ $name ?: 'Type Name' }}</div>
                                    <small class="text-muted">{{ $slug ?: 'type-slug' }}</small>
                                </div>
                                <div class="ms-auto">
                                    <i class="{{ $icon ?: 'fas fa-envelope' }} text-muted"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>{{ $editMode ? 'Update' : 'Create' }} Type
                            </button>
                            <a href="{{ route('admin.email-template-types') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Quill.js Rich Text Editor -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<style>
/* Quill.js Container Styling - Force containment within card body */
.ql-editor {
    max-width: 100% !important;
    width: 100% !important;
    overflow-wrap: break-word !important;
    word-wrap: break-word !important;
    word-break: break-word !important;
    box-sizing: border-box !important;
    padding: 8px 12px !important;
    min-height: 100px !important;
}

.ql-toolbar {
    max-width: 100% !important;
    width: 100% !important;
    overflow-x: auto !important;
    box-sizing: border-box !important;
    padding: 8px !important;
}

.ql-container {
    max-width: 100% !important;
    width: 100% !important;
    box-sizing: border-box !important;
    margin: 0 !important;
    padding: 0 !important;
}

#description {
    max-width: 100% !important;
    width: 100% !important;
    overflow: hidden !important;
    margin: 0 !important;
    padding: 0 !important;
}

/* Force Quill to stay within card body */
.card-body #description {
    width: 100% !important;
    max-width: 100% !important;
    overflow: hidden !important;
}

.card-body .ql-toolbar {
    width: 100% !important;
    max-width: 100% !important;
    overflow-x: auto !important;
}

.card-body .ql-container {
    width: 100% !important;
    max-width: 100% !important;
    overflow: hidden !important;
}

.card-body .ql-editor {
    width: 100% !important;
    max-width: 100% !important;
    overflow-wrap: break-word !important;
}

/* Ensure the editor stays within bounds */
.ql-snow .ql-toolbar {
    border-left: 1px solid #ccc !important;
    border-right: 1px solid #ccc !important;
    border-top: 1px solid #ccc !important;
    border-bottom: none !important;
}

.ql-snow .ql-container {
    border-left: 1px solid #ccc !important;
    border-right: 1px solid #ccc !important;
    border-bottom: 1px solid #ccc !important;
    border-top: none !important;
}

/* Additional containment rules */
.ql-snow {
    max-width: 100% !important;
    width: 100% !important;
}

/* Prevent any overflow */
.card-body {
    overflow: hidden !important;
}

/* Ensure form control doesn't exceed container */
.form-control {
    max-width: 100% !important;
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Quill.js
    const quill = new Quill('#description', {
        theme: 'snow',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'align': [] }],
                ['link'],
                ['clean']
            ]
        },
        placeholder: 'Enter type description...',
        bounds: '#description'
    });

    // Update Livewire component when content changes
    quill.on('text-change', function() {
        @this.set('description', quill.root.innerHTML);
    });
    
    // Set initial content if editing
    if (@this.description) {
        quill.root.innerHTML = @this.description;
    }
    
    // Update Quill content when Livewire updates
    document.addEventListener('livewire:update', function() {
        if (@this.description && quill.root.innerHTML !== @this.description) {
            quill.root.innerHTML = @this.description || '';
        }
    });
});
</script>
</div>