<div class="flash-message-container" id="flash-message-container">
    @if($showMessages && !empty($messages))
        <div class="flash-messages-wrapper">
            @foreach($messages as $message)
                <div class="flash-message flash-message-{{ $message['type'] }}" 
                     id="flash-{{ $message['id'] }}"
                     data-duration="{{ $message['duration'] }}"
                     wire:key="{{ $message['id'] }}">
                    <div class="flash-message-content">
                        <div class="flash-message-icon">
                            @if($message['type'] === 'success')
                                <i class="fas fa-check-circle"></i>
                            @elseif($message['type'] === 'error')
                                <i class="fas fa-exclamation-circle"></i>
                            @elseif($message['type'] === 'warning')
                                <i class="fas fa-exclamation-triangle"></i>
                            @elseif($message['type'] === 'info')
                                <i class="fas fa-info-circle"></i>
                            @endif
                        </div>
                        <div class="flash-message-text">
                            @if($message['title'])
                                <div class="flash-message-title">{{ $message['title'] }}</div>
                            @endif
                            <div class="flash-message-body">{{ $message['message'] }}</div>
                        </div>
                        <button type="button" 
                                class="flash-message-close" 
                                wire:click="removeMessage('{{ $message['id'] }}')"
                                aria-label="Close message">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    @if($message['duration'] > 0)
                        <div class="flash-message-progress" 
                             data-duration="{{ $message['duration'] }}"></div>
                    @endif
                </div>
            @endforeach
        </div>
    @endif
</div>