<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-clean">
        <div class="row align-items-center">
            <div class="col">
                <div class="d-flex align-items-center mb-3">
                    <h1 class="page-title-clean me-3">
                        <i class="fas fa-question-circle me-2"></i>
                        Help Center
                    </h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-clean">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-question-circle me-1"></i>
                            Help Center
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- FAQ Section -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-question-circle me-2"></i>Frequently Asked Questions
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Search and Filter -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       class="form-control" 
                                       placeholder="Search FAQs..." 
                                       wire:model.live.debounce.300ms="search">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <select class="form-select" wire:model.live="selectedCategory">
                                <option value="all">All Categories</option>
                                <option value="general">General</option>
                                <option value="permissions">Permissions</option>
                                <option value="system">System</option>
                            </select>
                        </div>
                    </div>

                    <!-- FAQ Items -->
                    <div class="accordion" id="faqAccordion">
                        @forelse($filteredFaqs as $index => $faq)
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button {{ $index === 0 ? '' : 'collapsed' }}" 
                                        type="button" 
                                        data-bs-toggle="collapse" 
                                        data-bs-target="#faq{{ $index }}"
                                        aria-expanded="{{ $index === 0 ? 'true' : 'false' }}">
                                    {{ $faq['question'] }}
                                </button>
                            </h2>
                            <div id="faq{{ $index }}" 
                                 class="accordion-collapse collapse {{ $index === 0 ? 'show' : '' }}" 
                                 data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    {{ $faq['answer'] }}
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="text-center py-4">
                            <div class="text-muted">
                                <i class="fas fa-search fa-2x mb-2"></i>
                                <p>No FAQs found matching your search criteria.</p>
                            </div>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Form -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-envelope me-2"></i>Contact Support
                    </h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="submitContactForm">
                        <div class="mb-3">
                            <label for="name" class="form-label">Name *</label>
                            <input type="text" 
                                   class="form-control @error('contactForm.name') is-invalid @enderror" 
                                   id="name" 
                                   wire:model="contactForm.name" 
                                   placeholder="Your name">
                            @error('contactForm.name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email *</label>
                            <input type="email" 
                                   class="form-control @error('contactForm.email') is-invalid @enderror" 
                                   id="email" 
                                   wire:model="contactForm.email" 
                                   placeholder="your.email@example.com">
                            @error('contactForm.email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="subject" class="form-label">Subject *</label>
                            <input type="text" 
                                   class="form-control @error('contactForm.subject') is-invalid @enderror" 
                                   id="subject" 
                                   wire:model="contactForm.subject" 
                                   placeholder="Brief description of your issue">
                            @error('contactForm.subject') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="message" class="form-label">Message *</label>
                            <textarea class="form-control @error('contactForm.message') is-invalid @enderror" 
                                      id="message" 
                                      wire:model="contactForm.message" 
                                      rows="4" 
                                      placeholder="Please describe your issue in detail..."></textarea>
                            @error('contactForm.message') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <button type="submit" class="btn btn-primary w-100" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="submitContactForm">
                                <i class="fas fa-paper-plane me-2"></i>Send Message
                            </span>
                            <span wire:loading wire:target="submitContactForm">
                                <i class="fas fa-spinner fa-spin me-2"></i>Sending...
                            </span>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-link me-2"></i>Quick Links
                    </h5>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <a href="{{ route('admin.users') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-users me-2"></i>Manage Users
                        </a>
                        <a href="{{ route('admin.roles') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-user-tag me-2"></i>Manage Roles
                        </a>
                        <a href="{{ route('admin.permissions') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-shield-alt me-2"></i>Manage Permissions
                        </a>
                        <a href="{{ route('admin.profile') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-user me-2"></i>My Profile
                        </a>
                        <a href="{{ route('admin.settings') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-cog me-2"></i>Settings
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>