<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-users"></i>
                <span class="d-none d-sm-inline">Manage Learner Forms</span>
                <span class="d-sm-none">Learner Forms</span>
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-users me-1"></i>Learner Forms
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                @can('learners.create')
                <a href="{{ route('admin.learner-forms.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    <span class="d-none d-sm-inline">Create New Form</span>
                    <span class="d-sm-none">New Form</span>
                </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-lg-6 col-md-12">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       class="form-control" 
                                       wire:model.live.debounce.300ms="search" 
                                       placeholder="Search forms by name or description...">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <div class="d-flex justify-content-lg-end justify-content-md-start">
                                <span class="badge bg-primary fs-6">
                                    Total: {{ $forms->total() }} forms
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Forms Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list me-2"></i>Learner Forms List
                    </h5>
                </div>
                <div class="card-body p-0">
                    @if($forms->count() > 0)
                        <!-- Desktop Table View -->
                        <div class="table-responsive d-none d-lg-block">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th wire:click="sortBy('name')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-heading me-1"></i>Form Name
                                            @if($sortBy === 'name')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                            @endif
                                        </th>
                                        <th wire:click="sortBy('description')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-align-left me-1"></i>Description
                                            @if($sortBy === 'description')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                            @endif
                                        </th>
                                        <th class="text-center">
                                            <i class="fas fa-cogs me-1"></i>Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($forms as $form)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-2">
                                                        <i class="fas fa-file-alt text-primary"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold">{{ $form->name }}</div>
                                                        <small class="text-muted">
                                                            {{ $form->fields->count() }} fields
                                                        </small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    @if($form->description)
                                                        <div class="text-muted">{{ $form->description }}</div>
                                                    @else
                                                        <div class="text-muted fst-italic">No description provided</div>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    @can('learners.edit')
                                                    <a href="{{ route('admin.learner-forms.edit', $form->id) }}" 
                                                       class="btn btn-sm btn-outline-warning" 
                                                       title="Edit Form">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @endcan
                                                    @can('learners.edit')
                                                    <button type="button" 
                                                            class="btn btn-sm {{ $form->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }}" 
                                                            wire:click="toggleStatus({{ $form->id }})"
                                                            title="{{ $form->is_active ? 'Deactivate' : 'Activate' }}">
                                                        <i class="fas fa-{{ $form->is_active ? 'pause' : 'play' }}"></i>
                                                    </button>
                                                    @endcan
                                                    @can('learners.delete')
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger" 
                                                            wire:click="deleteForm({{ $form->id }})"
                                                            wire:confirm="Are you sure you want to delete this form?"
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endcan
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Mobile Card View -->
                        <div class="d-lg-none">
                            @foreach($forms as $form)
                                <div class="card mb-3">
                                    <div class="card-body p-3">
                                        <div class="row align-items-start mb-3">
                                            <div class="col-auto">
                                                <i class="fas fa-file-alt text-primary fa-2x"></i>
                                            </div>
                                            <div class="col">
                                                <h6 class="card-title mb-1 fw-semibold text-truncate">{{ $form->name }}</h6>
                                                <p class="card-text text-muted small mb-1">{{ $form->fields->count() }} fields</p>
                                                @if($form->description)
                                                    <p class="card-text text-muted small mb-0">{{ Str::limit($form->description, 80) }}</p>
                                                @else
                                                    <p class="card-text text-muted small mb-0 fst-italic">No description provided</p>
                                                @endif
                                            </div>
                                        </div>
                                        
                                        <!-- Action Buttons -->
                                        <div class="row g-2">
                                            @can('learners.edit')
                                            <div class="col-6">
                                                <a href="{{ route('admin.learner-forms.edit', $form->id) }}" 
                                                   class="btn btn-sm btn-outline-warning w-100">
                                                    <i class="fas fa-edit me-1"></i>Edit
                                                </a>
                                            </div>
                                            @endcan
                                            @can('learners.edit')
                                            <div class="col-6">
                                                <button type="button" 
                                                        class="btn btn-sm {{ $form->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }} w-100" 
                                                        wire:click="toggleStatus({{ $form->id }})">
                                                    <i class="fas fa-{{ $form->is_active ? 'pause' : 'play' }} me-1"></i>
                                                    {{ $form->is_active ? 'Deactivate' : 'Activate' }}
                                                </button>
                                            </div>
                                            @endcan
                                            @can('learners.delete')
                                            <div class="col-12">
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger w-100" 
                                                        wire:click="deleteForm({{ $form->id }})"
                                                        wire:confirm="Are you sure you want to delete this form?">
                                                    <i class="fas fa-trash me-1"></i>Delete
                                                </button>
                                            </div>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Pagination -->
                        <div class="card-footer">
                            {{ $forms->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Forms Found</h5>
                            <p class="text-muted px-3">
                                @if($search || $statusFilter)
                                    No forms match your current filters.
                                @else
                                    Get started by creating your first learner form.
                                @endif
                            </p>
                            @can('learners.create')
                            <a href="{{ route('admin.learner-forms.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                <span class="d-none d-sm-inline">Create New Form</span>
                                <span class="d-sm-none">New Form</span>
                            </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>