<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-question-circle"></i>
                Questions for "{{ $quiz->title }}"
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes') }}">
                                <i class="fas fa-clipboard me-1"></i>Quizzes
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes.show', $quiz) }}">
                                <i class="fas fa-eye me-1"></i>{{ $quiz->title }}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Questions
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Actions and Filters -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="d-flex gap-2">
                <a href="{{ route('admin.quizzes.questions.create', $quiz) }}" class="btn btn-primary">
                    <i class="fas fa-plus me-1"></i>Add New Question
                </a>
                <a href="{{ route('admin.quizzes.show', $quiz) }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i>Back to Quiz
                </a>
            </div>
        </div>
        <div class="col-md-4">
            <div class="d-flex gap-2">
                <input type="text" 
                       class="form-control" 
                       placeholder="Search questions..." 
                       wire:model.live="search">
                <select class="form-select" wire:model.live="typeFilter">
                    <option value="">All Types</option>
                    @foreach($questionTypes as $key => $label)
                        <option value="{{ $key }}">{{ $label }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <!-- Questions List -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-list me-2"></i>Questions ({{ $questions->total() }})
                        </h5>
                        @if($questions->count() > 0)
                            <button class="btn btn-sm btn-outline-primary" onclick="toggleSortable()">
                                <i class="fas fa-sort me-1"></i>Reorder
                            </button>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if($questions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">#</th>
                                        <th>
                                            <button class="btn btn-link p-0 text-decoration-none" wire:click="sortBy('question_text')">
                                                Question
                                                @if($sortField === 'question_text')
                                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                                @endif
                                            </button>
                                        </th>
                                        <th>
                                            <button class="btn btn-link p-0 text-decoration-none" wire:click="sortBy('question_type')">
                                                Type
                                                @if($sortField === 'question_type')
                                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                                @endif
                                            </button>
                                        </th>
                                        <th>
                                            <button class="btn btn-link p-0 text-decoration-none" wire:click="sortBy('score_points')">
                                                Points
                                                @if($sortField === 'score_points')
                                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                                @endif
                                            </button>
                                        </th>
                                        <th>Status</th>
                                        <th style="width: 120px;">Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="sortable-questions">
                                    @foreach($questions as $index => $question)
                                    <tr data-question-id="{{ $question->id }}">
                                        <td>
                                            <span class="badge bg-primary">{{ $question->order }}</span>
                                        </td>
                                        <td>
                                            <div class="question-preview">
                                                <div class="fw-semibold mb-1">
                                                    {{ Str::limit($question->question_text, 100) }}
                                                </div>
                                                @if($question->metadata['feedback'] ?? null)
                                                    <small class="text-muted">
                                                        <i class="fas fa-comment me-1"></i>{{ Str::limit($question->metadata['feedback'], 50) }}
                                                    </small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $questionTypes[$question->type] ?? $question->type }}</span>
                                        </td>
                                        <td>
                                            <span class="fw-semibold">{{ $question->score_points }}</span>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column gap-1">
                                                @if($question->is_active)
                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-secondary">Inactive</span>
                                                @endif
                                                @if($question->is_required)
                                                    <span class="badge bg-warning">Required</span>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.quizzes.questions.edit', [$quiz, $question]) }}" 
                                                   class="btn btn-outline-primary" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        onclick="showDeleteQuestionModal({{ $question->id }}, '{{ addslashes($question->question_text) }}')"
                                                        title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                Showing {{ $questions->firstItem() }} to {{ $questions->lastItem() }} of {{ $questions->total() }} questions
                            </div>
                            <div>
                                {{ $questions->links() }}
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No questions found</h5>
                            <p class="text-muted">
                                @if($search || $typeFilter)
                                    No questions match your current filters.
                                    <button class="btn btn-link p-0" wire:click="clearFilters">Clear filters</button>
                                @else
                                    Get started by adding your first question to this quiz.
                                @endif
                            </p>
                            @if(!$search && !$typeFilter)
                                <a href="{{ route('admin.quizzes.questions.create', $quiz) }}" class="btn btn-primary">
                                    <i class="fas fa-plus me-1"></i>Add First Question
                                </a>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>


</div>



@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>

<script>
    function toggleSortable() {
        const tbody = document.getElementById('sortable-questions');
        if (tbody.hasAttribute('data-sortable')) {
            // Disable sortable
            tbody.removeAttribute('data-sortable');
            tbody.style.cursor = 'default';
            // Remove sortable instance
            if (tbody.sortable) {
                tbody.sortable.destroy();
            }
        } else {
            // Enable sortable
            tbody.setAttribute('data-sortable', 'true');
            tbody.style.cursor = 'move';
            // Initialize sortable
            tbody.sortable = Sortable.create(tbody, {
                animation: 150,
                onEnd: function(evt) {
                    const questionIds = Array.from(tbody.children).map(row => row.dataset.questionId);
                    @this.call('reorderQuestions', questionIds);
                }
            });
        }
    }
</script>
@endpush