<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit Quiz' : 'Create New Quiz' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes') }}">
                                <i class="fas fa-clipboard me-1"></i>Quizzes
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ $editMode ? 'Edit Quiz' : 'Create Quiz' }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Quiz Form -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Quiz Information
                    </h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="save">
                        <div class="row g-3">
                            <!-- Title -->
                            <div class="col-12">
                                <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('title') is-invalid @enderror" 
                                       id="title" 
                                       wire:model="title" 
                                       placeholder="Enter quiz title">
                                @error('title') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Description -->
                            <div class="col-12">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                          id="description" 
                                          wire:model="description" 
                                          rows="3" 
                                          placeholder="Enter quiz description"></textarea>
                                @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Slug -->
                            <div class="col-md-6">
                                <label for="slug" class="form-label">Slug</label>
                                <input type="text" 
                                       class="form-control @error('slug') is-invalid @enderror" 
                                       id="slug" 
                                       wire:model="slug" 
                                       placeholder="quiz-slug">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                <small class="form-text text-muted">URL-friendly version of the title</small>
                            </div>

                            <!-- Visibility -->
                            <div class="col-md-6">
                                <label for="visibility" class="form-label">Visibility <span class="text-danger">*</span></label>
                                <select class="form-select @error('visibility') is-invalid @enderror" 
                                        id="visibility" 
                                        wire:model="visibility">
                                    <option value="private">Private</option>
                                    <option value="public">Public</option>
                                    <option value="unlisted">Unlisted</option>
                                </select>
                                @error('visibility') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Expires At -->
                            <div class="col-md-6">
                                <label for="expiresAt" class="form-label">Expires At</label>
                                <input type="datetime-local" 
                                       class="form-control @error('expiresAt') is-invalid @enderror" 
                                       id="expiresAt" 
                                       wire:model="expiresAt">
                                @error('expiresAt') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Active Status -->
                            <div class="col-md-6">
                                <div class="form-check form-switch mt-4">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="isActive" 
                                           wire:model="isActive">
                                    <label class="form-check-label" for="isActive">
                                        Active
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Quiz Settings -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-cogs me-2"></i>Quiz Settings
                                </h6>
                            </div>
                        </div>

                        <div class="row g-3">
                            <!-- Duration -->
                            <div class="col-md-6">
                                <label for="duration" class="form-label">Duration (minutes)</label>
                                <input type="number" 
                                       class="form-control" 
                                       id="duration" 
                                       wire:model="settings.duration_minutes" 
                                       placeholder="Leave empty for no time limit">
                            </div>

                            <!-- Max Attempts -->
                            <div class="col-md-6">
                                <label for="maxAttempts" class="form-label">Max Attempts</label>
                                <input type="number" 
                                       class="form-control" 
                                       id="maxAttempts" 
                                       wire:model="settings.max_attempts" 
                                       placeholder="Leave empty for unlimited">
                            </div>

                            <!-- Show Correct Answers -->
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="showCorrectAnswers" 
                                           wire:model="settings.show_correct_answers">
                                    <label class="form-check-label" for="showCorrectAnswers">
                                        Show Correct Answers
                                    </label>
                                </div>
                            </div>

                            <!-- Randomize Questions -->
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="randomizeQuestions" 
                                           wire:model="settings.randomize_questions">
                                    <label class="form-check-label" for="randomizeQuestions">
                                        Randomize Questions
                                    </label>
                                </div>
                            </div>

                            <!-- Randomize Answers -->
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="randomizeAnswers" 
                                           wire:model="settings.randomize_answers">
                                    <label class="form-check-label" for="randomizeAnswers">
                                        Randomize Answers
                                    </label>
                                </div>
                            </div>

                            <!-- Allow Navigation -->
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="allowNavigation" 
                                           wire:model="settings.allow_navigation">
                                    <label class="form-check-label" for="allowNavigation">
                                        Allow Navigation
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <button type="button" 
                                            class="btn btn-outline-secondary" 
                                            wire:click="cancel">
                                        <i class="fas fa-times me-1"></i>Cancel
                                    </button>
                                    <button type="submit" 
                                            class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i>{{ $editMode ? 'Update Quiz' : 'Create Quiz' }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>