<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-folder"></i>
                <span class="d-none d-sm-inline">Resources Management</span>
                <span class="d-sm-none">Resources</span>
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-folder me-1"></i>Resources
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                @can('resources.create')
                <a href="{{ route('admin.resources.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    <span class="d-none d-sm-inline">Add New Resource</span>
                    <span class="d-sm-none">Add Resource</span>
                </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-lg-6 col-md-12">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       class="form-control" 
                                       wire:model.live.debounce.300ms="search" 
                                       placeholder="Search resources by title or description...">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <div class="d-flex justify-content-lg-end justify-content-md-start">
                                <span class="badge bg-primary fs-6">
                                    Total: {{ $resources->total() }} resources
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Resources Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list me-2"></i>Resources List
                    </h5>
                </div>
                <div class="card-body p-0">
                    @if($resources->count() > 0)
                        <!-- Desktop Table View -->
                        <div class="table-responsive d-none d-lg-block">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th wire:click="sortBy('title')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-heading me-1"></i>Title
                                            @if($sortBy === 'title')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                            @endif
                                        </th>
                                        <th wire:click="sortBy('description')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-align-left me-1"></i>Description
                                            @if($sortBy === 'description')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                            @endif
                                        </th>
                                        <th class="text-center">
                                            <i class="fas fa-cogs me-1"></i>Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($resources as $resource)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-2">
                                                        <i class="{{ $resource->file_icon }}"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold">{{ $resource->title }}</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    @if($resource->description)
                                                        <div class="text-muted">{{ $resource->description }}</div>
                                                    @else
                                                        <div class="text-muted fst-italic">No description provided</div>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a href="{{ $resource->file_url }}" 
                                                       class="btn btn-sm btn-outline-primary" 
                                                       target="_blank"
                                                       title="Download">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                    @can('resources.edit')
                                                    <a href="{{ route('admin.resources.edit', $resource->id) }}" 
                                                       class="btn btn-sm btn-outline-warning" 
                                                       title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @endcan
                                                    @can('resources.edit')
                                                    <button type="button" 
                                                            class="btn btn-sm {{ $resource->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }}" 
                                                            wire:click="toggleStatus({{ $resource->id }})"
                                                            title="{{ $resource->is_active ? 'Deactivate' : 'Activate' }}">
                                                        <i class="fas fa-{{ $resource->is_active ? 'pause' : 'play' }}"></i>
                                                    </button>
                                                    @endcan
                                                    @can('resources.delete')
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger" 
                                                            wire:click="deleteResource({{ $resource->id }})"
                                                            wire:confirm="Are you sure you want to delete this resource?"
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endcan
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Mobile Card View -->
                        <div class="d-lg-none">
                            @foreach($resources as $resource)
                                <div class="card mb-3">
                                    <div class="card-body p-3">
                                        <div class="row align-items-start mb-3">
                                            <div class="col-auto">
                                                <i class="{{ $resource->file_icon }} fa-2x text-primary"></i>
                                            </div>
                                            <div class="col">
                                                <h6 class="card-title mb-1 fw-semibold text-truncate">{{ $resource->title }}</h6>
                                                @if($resource->description)
                                                    <p class="card-text text-muted small mb-0">{{ Str::limit($resource->description, 80) }}</p>
                                                @else
                                                    <p class="card-text text-muted small mb-0 fst-italic">No description provided</p>
                                                @endif
                                            </div>
                                        </div>
                                        
                                        <!-- Action Buttons -->
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <a href="{{ $resource->file_url }}" 
                                                   class="btn btn-sm btn-outline-primary w-100" 
                                                   target="_blank">
                                                    <i class="fas fa-download me-1"></i>Download
                                                </a>
                                            </div>
                                            @can('resources.edit')
                                            <div class="col-6">
                                                <a href="{{ route('admin.resources.edit', $resource->id) }}" 
                                                   class="btn btn-sm btn-outline-warning w-100">
                                                    <i class="fas fa-edit me-1"></i>Edit
                                                </a>
                                            </div>
                                            @endcan
                                            @can('resources.edit')
                                            <div class="col-6">
                                                <button type="button" 
                                                        class="btn btn-sm {{ $resource->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }} w-100" 
                                                        wire:click="toggleStatus({{ $resource->id }})">
                                                    <i class="fas fa-{{ $resource->is_active ? 'pause' : 'play' }} me-1"></i>
                                                    {{ $resource->is_active ? 'Deactivate' : 'Activate' }}
                                                </button>
                                            </div>
                                            @endcan
                                            @can('resources.delete')
                                            <div class="col-6">
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger w-100" 
                                                        wire:click="deleteResource({{ $resource->id }})"
                                                        wire:confirm="Are you sure you want to delete this resource?">
                                                    <i class="fas fa-trash me-1"></i>Delete
                                                </button>
                                            </div>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Pagination -->
                        <div class="card-footer">
                            {{ $resources->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Resources Found</h5>
                            <p class="text-muted px-3">
                                @if($search || $statusFilter)
                                    No resources match your current filters.
                                @else
                                    Get started by creating your first resource.
                                @endif
                            </p>
                            @can('resources.create')
                            <a href="{{ route('admin.resources.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                <span class="d-none d-sm-inline">Add New Resource</span>
                                <span class="d-sm-none">Add Resource</span>
                            </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>