<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-user-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit User' : 'Add New User' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.users') }}">
                                <i class="fas fa-users me-1"></i>Users
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-1"></i>
                            {{ $editMode ? 'Edit User' : 'Add User' }}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <a href="{{ route('admin.users') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Users
                </a>
            </div>
        </div>
    </div>

    <!-- Form Content -->
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10 col-lg-11">
                <!-- Form Card -->
                <div class="card shadow-sm">
                    <div class="card-header bg-light">
                        <div class="row align-items-center">
                            <div class="col">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-user-{{ $editMode ? 'edit' : 'plus' }} me-2 text-primary"></i>
                                    {{ $editMode ? 'Edit User Information' : 'Create New User' }}
                                </h5>
                                <p class="text-muted mb-0 mt-1">
                                    {{ $editMode ? 'Update user details and permissions' : 'Fill in the information below to create a new user account' }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                    <form wire:submit.prevent="save" id="userForm">
                        <!-- Basic Information -->
                        <div class="mb-4">
                            <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">
                                <i class="fas fa-user me-2"></i>Basic Information
                            </h6>
                            <div class="row g-3">
                                <div class="col-12 col-md-6">
                                    <label for="name" class="form-label fw-semibold">
                                        <i class="fas fa-user me-1 text-muted"></i>Full Name *
                                    </label>
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           id="name" 
                                           wire:model="name" 
                                           placeholder="Enter full name"
                                           autocomplete="name"
                                           required>
                                    @error('name') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                <div class="col-12 col-md-6">
                                    <label for="email" class="form-label fw-semibold">
                                        <i class="fas fa-envelope me-1 text-muted"></i>Email Address *
                                    </label>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           id="email" 
                                           wire:model="email" 
                                           placeholder="Enter email address"
                                           autocomplete="email"
                                           required>
                                    @error('email') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Security Information -->
                        <div class="mb-4">
                            <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">
                                <i class="fas fa-lock me-2"></i>Security Information
                            </h6>
                            <div class="row g-3">
                                <div class="col-12 col-md-6">
                                    <label for="password" class="form-label fw-semibold">
                                        <i class="fas fa-lock me-1 text-muted"></i>Password {{ $editMode ? '(leave blank to keep current)' : '*' }}
                                    </label>
                                    <div class="input-group">
                                        <input type="password" 
                                               class="form-control @error('password') is-invalid @enderror" 
                                               id="password" 
                                               wire:model="password" 
                                               placeholder="Enter password"
                                               autocomplete="new-password"
                                               {{ !$editMode ? 'required' : '' }}>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password')">
                                            <i class="fas fa-eye" id="password-eye"></i>
                                        </button>
                                    </div>
                                    @error('password') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                <div class="col-12 col-md-6">
                                    <label for="password_confirmation" class="form-label fw-semibold">
                                        <i class="fas fa-lock me-1 text-muted"></i>Confirm Password
                                    </label>
                                    <div class="input-group">
                                        <input type="password" 
                                               class="form-control @error('password_confirmation') is-invalid @enderror" 
                                               id="password_confirmation" 
                                               wire:model="password_confirmation" 
                                               placeholder="Confirm password"
                                               autocomplete="new-password"
                                               {{ !$editMode ? 'required' : '' }}>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password_confirmation')">
                                            <i class="fas fa-eye" id="password_confirmation-eye"></i>
                                        </button>
                                    </div>
                                    @error('password_confirmation') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Role and Contact Information -->
                        <div class="mb-4">
                            <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">
                                <i class="fas fa-user-tag me-2"></i>Role & Contact Information
                            </h6>
                            <div class="row g-3">
                                <div class="col-12 col-md-6">
                                    <label for="role" class="form-label fw-semibold">
                                        <i class="fas fa-user-tag me-1 text-muted"></i>Role *
                                    </label>
                                    <select class="form-select @error('role') is-invalid @enderror" 
                                            id="role" 
                                            wire:model="role"
                                            required>
                                        <option value="">Select a role</option>
                                        @foreach($availableRoles as $role)
                                            <option value="{{ $role->name }}">{{ ucfirst($role->name) }}</option>
                                        @endforeach
                                    </select>
                                    @error('role') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                <div class="col-12 col-md-6">
                                    <label for="phone" class="form-label fw-semibold">
                                        <i class="fas fa-phone me-1 text-muted"></i>Phone Number
                                    </label>
                                    <input type="tel" 
                                           class="form-control @error('phone') is-invalid @enderror" 
                                           id="phone" 
                                           wire:model="phone" 
                                           placeholder="Enter phone number"
                                           autocomplete="tel">
                                    @error('phone') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        <div class="mb-4">
                            <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">
                                <i class="fas fa-info-circle me-2"></i>Additional Information
                            </h6>
                            <div class="row g-3">
                                <div class="col-12 col-md-6">
                                    <label for="date_of_birth" class="form-label fw-semibold">
                                        <i class="fas fa-calendar me-1 text-muted"></i>Date of Birth
                                    </label>
                                    <input type="date" 
                                           class="form-control @error('date_of_birth') is-invalid @enderror" 
                                           id="date_of_birth" 
                                           wire:model="date_of_birth"
                                           max="{{ date('Y-m-d') }}">
                                    @error('date_of_birth') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                <div class="col-12 col-md-6">
                                    <label for="is_active" class="form-label fw-semibold">
                                        <i class="fas fa-toggle-on me-1 text-muted"></i>Status
                                    </label>
                                    <select class="form-select @error('is_active') is-invalid @enderror" 
                                            id="is_active" 
                                            wire:model="is_active">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                    @error('is_active') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <label for="address" class="form-label fw-semibold">
                                        <i class="fas fa-map-marker-alt me-1 text-muted"></i>Address
                                    </label>
                                    <textarea class="form-control @error('address') is-invalid @enderror resize-vertical" 
                                              id="address" 
                                              wire:model="address" 
                                              rows="3" 
                                              placeholder="Enter address"></textarea>
                                    @error('address') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                    <div class="card-footer bg-light">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex flex-column flex-md-row justify-content-between gap-2">
                                    <button type="button" class="btn btn-secondary" wire:click="cancel">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </button>
                                    <button type="button" class="btn btn-primary" wire:click="save" wire:loading.attr="disabled">
                                        <span wire:loading.remove wire:target="save">
                                            <i class="fas fa-{{ $editMode ? 'save' : 'plus' }} me-2"></i>
                                            {{ $editMode ? 'Update User' : 'Create User' }}
                                        </span>
                                        <span wire:loading wire:target="save">
                                            <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>