<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-users"></i>
                User Management
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-users me-1"></i>Users
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                @can('users.create')
                <button type="button" class="btn btn-primary" wire:click="openModal()">
                    <i class="fas fa-plus me-2"></i>Add New User
                </button>
                @endcan
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">

                <div class="card-body">
                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-5">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search users..." wire:model.live="search">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Users</option>
                                <option value="1">Active Users</option>
                                <option value="0">Inactive Users</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex gap-2">
                                @if($search || $statusFilter !== '')
                                    <button type="button" class="btn btn-outline-secondary btn-sm" wire:click="clearFilters">
                                        <i class="fas fa-times me-1"></i>Clear Filters
                                    </button>
                                @endif
                                <div class="text-muted small align-self-center">
                                    <i class="fas fa-info-circle me-1"></i>
                                    {{ $users->total() }} user{{ $users->total() !== 1 ? 's' : '' }} found
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Inactive Users Notice -->
                    @if($statusFilter === '0' || ($statusFilter === '' && $users->where('is_active', false)->count() > 0))
                        <div class="alert alert-warning mb-3" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Inactive Users Notice:</strong> Inactive users cannot log in or access any functionality. They will be automatically logged out if they try to access the system.
                        </div>
                    @endif

                    <!-- Users Table -->
                    <div class="table-responsive d-none d-lg-block">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th wire:click="sortBy('name')" class="sortable">
                                        Name 
                                        @if($sortField === 'name')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th wire:click="sortBy('email')" class="sortable">
                                        Email 
                                        @if($sortField === 'email')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th>Role</th>
                                    <th>Phone</th>
                                    <th wire:click="sortBy('is_active')" class="sortable">
                                        Status 
                                        @if($sortField === 'is_active')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th wire:click="sortBy('created_at')" class="sortable">
                                        Created 
                                        @if($sortField === 'created_at')
                                            <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                        @endif
                                    </th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3 shadow-sm">
                                                    <span class="avatar-text">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
                                                </div>
                                                <div>
                                                    <div class="fw-bold">{{ $user->name }}</div>
                                                    @if($user->date_of_birth)
                                                        <small class="text-muted">Age: {{ \Carbon\Carbon::parse($user->date_of_birth)->age }}</small>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $user->email }}</td>
                                        <td>
                                            @if($user->roles->count() > 0)
                                                @foreach($user->roles as $role)
                                                    <span class="badge bg-info">{{ $role->name }}</span>
                                                @endforeach
                                            @else
                                                <span class="text-muted">No role assigned</span>
                                            @endif
                                        </td>
                                        <td>{{ $user->phone ?? 'N/A' }}</td>
                                        <td>
                                            @if($user->is_active)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-danger">Inactive</span>
                                            @endif
                                        </td>
                                        <td>{{ $user->created_at->format('M d, Y') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @can('users.edit')
                                                <button type="button" class="btn btn-sm btn-outline-primary" wire:click="openModal({{ $user->id }})" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                @endcan
                                                @can('users.delete')
                                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                                        wire:click="delete({{ $user->id }})"
                                                        wire:confirm="{{ $user->id === auth()->id() ? 'You cannot delete your own account!' : 'Are you sure you want to delete this user?' }}"
                                                        title="Delete"
                                                        {{ $user->id === auth()->id() ? 'disabled' : '' }}>
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-2x mb-2"></i>
                                                <p>No users found</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing {{ $users->firstItem() ?? 0 }} to {{ $users->lastItem() ?? 0 }} of {{ $users->total() }} results
                        </div>
                        <div>
                            {{ $users->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Card View -->
    @if($users->count() > 0)
        <div class="d-lg-none">
            @foreach($users as $user)
                <div class="card mb-3">
                    <div class="card-body p-3">
                        <div class="row align-items-start mb-3">
                            <div class="col-auto">
                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center shadow-sm">
                                    <span class="avatar-text">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
                                </div>
                            </div>
                            <div class="col">
                                <h6 class="card-title mb-1 fw-semibold">{{ $user->name }}</h6>
                                <p class="text-muted small mb-1">{{ $user->email }}</p>
                                <div class="d-flex flex-wrap gap-2 mb-2">
                                    @if($user->roles->count() > 0)
                                        @foreach($user->roles as $role)
                                            <span class="badge bg-info">{{ $role->name }}</span>
                                        @endforeach
                                    @else
                                        <span class="badge bg-secondary">No role</span>
                                    @endif
                                    @if($user->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </div>
                                <small class="text-muted">
                                    Phone: {{ $user->phone ?? 'N/A' }} | Created: {{ $user->created_at->format('M d, Y') }}
                                </small>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row g-2">
                            @can('users.edit')
                            <div class="col-6">
                                <button type="button" class="btn btn-sm btn-outline-primary w-100" wire:click="openModal({{ $user->id }})">
                                    <i class="fas fa-edit me-1"></i>Edit
                                </button>
                            </div>
                            @endcan
                            @can('users.delete')
                            <div class="col-6">
                                <button type="button" class="btn btn-sm btn-outline-danger w-100" 
                                        wire:click="delete({{ $user->id }})"
                                        wire:confirm="{{ $user->id === auth()->id() ? 'You cannot delete your own account!' : 'Are you sure you want to delete this user?' }}"
                                        {{ $user->id === auth()->id() ? 'disabled' : '' }}>
                                    <i class="fas fa-trash me-1"></i>Delete
                                </button>
                            </div>
                            @endcan
                        </div>
                    </div>
                </div>
            @endforeach
            
            <!-- Mobile Pagination -->
            @if($users->hasPages())
                <div class="d-flex justify-content-center mt-4">
                    {{ $users->links() }}
                </div>
            @endif
        </div>
    @endif
</div>