<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maintenance Mode - {{ $siteName }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="{{ url('/admin/css/maintenance.css') }}" rel="stylesheet">
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-header">
            <div class="maintenance-icon">
                <i class="fas fa-cog"></i>
            </div>
            <h1 class="maintenance-title">System Maintenance</h1>
            <p class="maintenance-subtitle">We're currently upgrading our services</p>
        </div>
        
        <div class="maintenance-content">
            <div class="maintenance-info-card">
                <div class="info-icon">
                    <i class="fas fa-info-circle"></i>
                </div>
                <div class="info-content">
                    <h3>What's happening?</h3>
                    <p>We're performing scheduled maintenance to enhance system performance and add new features. Our technical team is working diligently to ensure a smooth experience.</p>
                </div>
            </div>
            
            <div class="maintenance-progress">
                <div class="progress-icon">
                    <div class="spinner"></div>
                </div>
                <div class="progress-text">
                    <h4>Maintenance in Progress</h4>
                    <p>Please wait while we complete the system updates</p>
                </div>
            </div>
            
            <div class="maintenance-info-card">
                <div class="info-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="info-content">
                    <h3>Estimated Duration</h3>
                    <p>We anticipate completing the maintenance within the next 15-30 minutes. We'll notify you as soon as all services are restored.</p>
                </div>
            </div>
            
            <div class="maintenance-info-card">
                <div class="info-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <div class="info-content">
                    <h3>Stay Updated</h3>
                    <p>Follow our official channels for real-time updates on the maintenance progress and service restoration.</p>
                </div>
            </div>
        </div>
        
        <div class="maintenance-footer">
            <div class="admin-access">
                <div class="admin-icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <div class="admin-content">
                    <h5>Administrator Access</h5>
                    <p>Need immediate access? Administrators can still access the system.</p>
                    <a href="{{ url('/admin/dashboard') }}" class="admin-link">
                        <i class="fas fa-external-link-alt me-1"></i>
                        Access Admin Panel
                    </a>
                </div>
            </div>
            
            <div class="copyright-section">
                <p class="copyright-text">{{ $copyrightText }}</p>
                <div class="company-info">
                    <span class="company-name">{{ $siteName }}</span>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
