<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\QuizController;
use App\Http\Controllers\Api\QuizAttemptController;
use App\Http\Controllers\Api\QuizAnalyticsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public routes
Route::prefix('v1')->group(function () {
    // Public quiz routes
    Route::get('/quizzes/public', [QuizController::class, 'public']);
    Route::get('/quizzes/{quiz}/public', [QuizController::class, 'show']);
    Route::get('/quizzes/{quiz}/languages', [QuizController::class, 'getLanguages']);
    Route::get('/quizzes/{quiz}/language/{locale}', [QuizController::class, 'getInLanguage']);
});

// Protected routes
Route::middleware(['auth:sanctum'])->prefix('v1')->group(function () {
    
    // Quiz management routes
    Route::apiResource('quizzes', QuizController::class);
    Route::post('/quizzes/{quiz}/publish', [QuizController::class, 'publish']);
    Route::post('/quizzes/{quiz}/unpublish', [QuizController::class, 'unpublish']);
    Route::get('/quizzes/{quiz}/stats', [QuizController::class, 'stats']);
    Route::get('/quizzes/{quiz}/leaderboard', [QuizController::class, 'leaderboard']);
    Route::post('/quizzes/{quiz}/versions', [QuizController::class, 'createVersion']);
    Route::post('/quizzes/{quiz}/language/{locale}', [QuizController::class, 'setLanguage']);
    
    // Quiz attempt routes
    Route::post('/quizzes/{quiz}/attempts', [QuizAttemptController::class, 'start']);
    Route::get('/quizzes/{quiz}/attempts/current', [QuizAttemptController::class, 'current']);
    Route::get('/attempts', [QuizAttemptController::class, 'userAttempts']);
    Route::get('/attempts/{attempt}', [QuizAttemptController::class, 'show']);
    Route::post('/attempts/{attempt}/resume', [QuizAttemptController::class, 'resume']);
    Route::post('/attempts/{attempt}/answer', [QuizAttemptController::class, 'answer']);
    Route::post('/attempts/{attempt}/skip', [QuizAttemptController::class, 'skip']);
    Route::post('/attempts/{attempt}/navigate', [QuizAttemptController::class, 'navigate']);
    Route::get('/attempts/{attempt}/next-question', [QuizAttemptController::class, 'nextQuestion']);
    Route::get('/attempts/{attempt}/previous-question', [QuizAttemptController::class, 'previousQuestion']);
    Route::post('/attempts/{attempt}/complete', [QuizAttemptController::class, 'complete']);
    Route::post('/attempts/{attempt}/abandon', [QuizAttemptController::class, 'abandon']);
    Route::get('/attempts/{attempt}/results', [QuizAttemptController::class, 'results']);
    
    // Analytics routes
    Route::get('/analytics/quizzes/{quiz}', [QuizAnalyticsController::class, 'quizStats']);
    Route::get('/analytics/questions/{question}', [QuizAnalyticsController::class, 'questionStats']);
    Route::get('/analytics/users/{user}', [QuizAnalyticsController::class, 'userActivity']);
    Route::get('/analytics/dashboard', [QuizAnalyticsController::class, 'dashboard']);
    
    // User profile
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
});

// Webhook routes (no authentication required)
Route::prefix('v1/webhooks')->group(function () {
    Route::post('/quiz/{webhook}', function (Request $request, $webhook) {
        // Handle incoming webhook
        return response()->json(['success' => true]);
    });
});


