

<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-4 py-3">
        <!-- Page Header -->
        <div class="page-header-two-row">
            <div class="page-title-row">
                <h1 class="page-title-two-row">
                    <i class="fas fa-question-circle"></i>
                    <?php echo e($quiz->title); ?>

                </h1>
            </div>
            <div class="page-actions-row">
                <div class="breadcrumb-section">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('admin.dashboard')); ?>">
                                    <i class="fas fa-home me-1"></i>Dashboard
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('admin.quizzes')); ?>">
                                    <i class="fas fa-question-circle me-1"></i>Quizzes
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                <?php echo e($quiz->title); ?>

                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <!-- Quiz Details -->
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2"></i>Quiz Details
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Description</h6>
                                <p><?php echo e($quiz->description ?: 'No description provided'); ?></p>
                                
                                <h6>Status</h6>
                                <?php switch($quiz->status):
                                    case ('draft'): ?>
                                        <span class="badge bg-secondary">Draft</span>
                                        <?php break; ?>
                                    <?php case ('published'): ?>
                                        <span class="badge bg-success">Published</span>
                                        <?php break; ?>
                                    <?php case ('archived'): ?>
                                        <span class="badge bg-warning">Archived</span>
                                        <?php break; ?>
                                <?php endswitch; ?>
                                
                                <h6>Visibility</h6>
                                <?php switch($quiz->visibility):
                                    case ('private'): ?>
                                        <span class="badge bg-danger">Private</span>
                                        <?php break; ?>
                                    <?php case ('public'): ?>
                                        <span class="badge bg-success">Public</span>
                                        <?php break; ?>
                                    <?php case ('unlisted'): ?>
                                        <span class="badge bg-warning">Unlisted</span>
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </div>
                            <div class="col-md-6">
                                <h6>Statistics</h6>
                                <ul class="list-unstyled">
                                    <li><strong>Questions:</strong> <?php echo e($quiz->total_questions); ?></li>
                                    <li><strong>Total Points:</strong> <?php echo e($quiz->total_points); ?></li>
                                    <li><strong>Duration:</strong> <?php echo e($quiz->duration_minutes ? $quiz->duration_minutes . ' minutes' : 'No time limit'); ?></li>
                                    <li><strong>Version:</strong> <?php echo e($quiz->version); ?></li>
                                </ul>
                                
                                <h6>Timeline</h6>
                                <ul class="list-unstyled">
                                    <li><strong>Created:</strong> <?php echo e($quiz->created_at->format('M d, Y H:i')); ?></li>
                                    <?php if($quiz->published_at): ?>
                                        <li><strong>Published:</strong> <?php echo e($quiz->published_at->format('M d, Y H:i')); ?></li>
                                    <?php endif; ?>
                                    <?php if($quiz->expires_at): ?>
                                        <li><strong>Expires:</strong> <?php echo e($quiz->expires_at->format('M d, Y H:i')); ?></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Questions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-list me-2"></i>Questions (<?php echo e($quiz->questions->count()); ?>)
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php $__empty_1 = true; $__currentLoopData = $quiz->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="question-item border rounded p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <h6 class="mb-2">
                                        <span class="badge bg-primary me-2"><?php echo e($index + 1); ?></span>
                                        <?php echo e($question->question_text); ?>

                                    </h6>
                                    <div class="d-flex gap-3">
                                        <small class="text-muted">
                                            <i class="fas fa-tag me-1"></i><?php echo e($question->type_label); ?>

                                        </small>
                                        <small class="text-muted">
                                            <i class="fas fa-star me-1"></i><?php echo e($question->score_points); ?> points
                                        </small>
                                        <?php if($question->is_required): ?>
                                            <small class="text-danger">
                                                <i class="fas fa-asterisk me-1"></i>Required
                                            </small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-4">
                            <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No questions added yet</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-cogs me-2"></i>Actions
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('admin.quizzes.edit', $quiz)); ?>" class="btn btn-primary">
                                <i class="fas fa-edit me-1"></i>Edit Quiz
                            </a>
                            <a href="<?php echo e(route('admin.quizzes.questions', $quiz)); ?>" class="btn btn-info">
                                <i class="fas fa-question-circle me-1"></i>Manage Questions
                            </a>
                            <a href="<?php echo e(route('admin.quizzes.invitations', $quiz)); ?>" class="btn btn-warning">
                                <i class="fas fa-envelope me-1"></i>Send Invitations
                            </a>
                            <?php if($quiz->status === 'draft'): ?>
                                <button type="button" class="btn btn-success">
                                    <i class="fas fa-publish me-1"></i>Publish Quiz
                                </button>
                            <?php elseif($quiz->status === 'published'): ?>
                                <button type="button" class="btn btn-warning">
                                    <i class="fas fa-unpublish me-1"></i>Unpublish Quiz
                                </button>
                            <?php endif; ?>
                            <a href="<?php echo e(route('admin.quizzes.analytics', $quiz)); ?>" class="btn btn-info">
                                <i class="fas fa-chart-bar me-1"></i>View Analytics
                            </a>
                            <button type="button" class="btn btn-outline-secondary">
                                <i class="fas fa-copy me-1"></i>Duplicate Quiz
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-chart-pie me-2"></i>Quick Stats
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6">
                                <h4 class="text-primary"><?php echo e($quiz->attempts->count()); ?></h4>
                                <small class="text-muted">Total Attempts</small>
                            </div>
                            <div class="col-6">
                                <h4 class="text-success"><?php echo e($quiz->attempts->where('status', 'completed')->count()); ?></h4>
                                <small class="text-muted">Completed</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Creator Info -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Creator
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                <?php echo e(substr($quiz->creator->name ?? 'U', 0, 1)); ?>

                            </div>
                            <div>
                                <h6 class="mb-0"><?php echo e($quiz->creator->name ?? 'Unknown'); ?></h6>
                                <small class="text-muted"><?php echo e($quiz->creator->email ?? ''); ?></small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Admin.layouts.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/Admin/quiz-show.blade.php ENDPATH**/ ?>