<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-folder"></i>
                <span class="d-none d-sm-inline">Resources Management</span>
                <span class="d-sm-none">Resources</span>
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-folder me-1"></i>Resources
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.create')): ?>
                <a href="<?php echo e(route('admin.resources.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    <span class="d-none d-sm-inline">Add New Resource</span>
                    <span class="d-sm-none">Add Resource</span>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-lg-6 col-md-12">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       class="form-control" 
                                       wire:model.live.debounce.300ms="search" 
                                       placeholder="Search resources by title or description...">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12">
                            <div class="d-flex justify-content-lg-end justify-content-md-start">
                                <span class="badge bg-primary fs-6">
                                    Total: <?php echo e($resources->total()); ?> resources
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Resources Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list me-2"></i>Resources List
                    </h5>
                </div>
                <div class="card-body p-0">
                    <!--[if BLOCK]><![endif]--><?php if($resources->count() > 0): ?>
                        <!-- Desktop Table View -->
                        <div class="table-responsive d-none d-lg-block">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th wire:click="sortBy('title')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-heading me-1"></i>Title
                                            <!--[if BLOCK]><![endif]--><?php if($sortBy === 'title'): ?>
                                                <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </th>
                                        <th wire:click="sortBy('description')" class="text-nowrap" style="cursor: pointer;">
                                            <i class="fas fa-align-left me-1"></i>Description
                                            <!--[if BLOCK]><![endif]--><?php if($sortBy === 'description'): ?>
                                                <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </th>
                                        <th class="text-center">
                                            <i class="fas fa-cogs me-1"></i>Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-2">
                                                        <i class="<?php echo e($resource->file_icon); ?>"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold"><?php echo e($resource->title); ?></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <!--[if BLOCK]><![endif]--><?php if($resource->description): ?>
                                                        <div class="text-muted"><?php echo e($resource->description); ?></div>
                                                    <?php else: ?>
                                                        <div class="text-muted fst-italic">No description provided</div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e($resource->file_url); ?>" 
                                                       class="btn btn-sm btn-outline-primary" 
                                                       target="_blank"
                                                       title="Download">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.edit')): ?>
                                                    <a href="<?php echo e(route('admin.resources.edit', $resource->id)); ?>" 
                                                       class="btn btn-sm btn-outline-warning" 
                                                       title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.edit')): ?>
                                                    <button type="button" 
                                                            class="btn btn-sm <?php echo e($resource->is_active ? 'btn-outline-secondary' : 'btn-outline-success'); ?>" 
                                                            wire:click="toggleStatus(<?php echo e($resource->id); ?>)"
                                                            title="<?php echo e($resource->is_active ? 'Deactivate' : 'Activate'); ?>">
                                                        <i class="fas fa-<?php echo e($resource->is_active ? 'pause' : 'play'); ?>"></i>
                                                    </button>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.delete')): ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger" 
                                                            wire:click="deleteResource(<?php echo e($resource->id); ?>)"
                                                            wire:confirm="Are you sure you want to delete this resource?"
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>

                        <!-- Mobile Card View -->
                        <div class="d-lg-none">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card mb-3">
                                    <div class="card-body p-3">
                                        <div class="row align-items-start mb-3">
                                            <div class="col-auto">
                                                <i class="<?php echo e($resource->file_icon); ?> fa-2x text-primary"></i>
                                            </div>
                                            <div class="col">
                                                <h6 class="card-title mb-1 fw-semibold text-truncate"><?php echo e($resource->title); ?></h6>
                                                <!--[if BLOCK]><![endif]--><?php if($resource->description): ?>
                                                    <p class="card-text text-muted small mb-0"><?php echo e(Str::limit($resource->description, 80)); ?></p>
                                                <?php else: ?>
                                                    <p class="card-text text-muted small mb-0 fst-italic">No description provided</p>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </div>
                                        
                                        <!-- Action Buttons -->
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <a href="<?php echo e($resource->file_url); ?>" 
                                                   class="btn btn-sm btn-outline-primary w-100" 
                                                   target="_blank">
                                                    <i class="fas fa-download me-1"></i>Download
                                                </a>
                                            </div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.edit')): ?>
                                            <div class="col-6">
                                                <a href="<?php echo e(route('admin.resources.edit', $resource->id)); ?>" 
                                                   class="btn btn-sm btn-outline-warning w-100">
                                                    <i class="fas fa-edit me-1"></i>Edit
                                                </a>
                                            </div>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.edit')): ?>
                                            <div class="col-6">
                                                <button type="button" 
                                                        class="btn btn-sm <?php echo e($resource->is_active ? 'btn-outline-secondary' : 'btn-outline-success'); ?> w-100" 
                                                        wire:click="toggleStatus(<?php echo e($resource->id); ?>)">
                                                    <i class="fas fa-<?php echo e($resource->is_active ? 'pause' : 'play'); ?> me-1"></i>
                                                    <?php echo e($resource->is_active ? 'Deactivate' : 'Activate'); ?>

                                                </button>
                                            </div>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.delete')): ?>
                                            <div class="col-6">
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger w-100" 
                                                        wire:click="deleteResource(<?php echo e($resource->id); ?>)"
                                                        wire:confirm="Are you sure you want to delete this resource?">
                                                    <i class="fas fa-trash me-1"></i>Delete
                                                </button>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Pagination -->
                        <div class="card-footer">
                            <?php echo e($resources->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Resources Found</h5>
                            <p class="text-muted px-3">
                                <!--[if BLOCK]><![endif]--><?php if($search || $statusFilter): ?>
                                    No resources match your current filters.
                                <?php else: ?>
                                    Get started by creating your first resource.
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.create')): ?>
                            <a href="<?php echo e(route('admin.resources.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                <span class="d-none d-sm-inline">Add New Resource</span>
                                <span class="d-sm-none">Add Resource</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/resource-management.blade.php ENDPATH**/ ?>