<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-user-tag"></i>
                Role Management
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-user-tag me-1"></i>Roles
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.create')): ?>
                <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Role
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Roles Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Roles List</h5>
                        </div>
                        <div class="col-auto">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       class="form-control" 
                                       placeholder="Search roles..." 
                                       wire:model.live.debounce.300ms="search">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive d-none d-lg-block">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th wire:click="sortBy('name')" class="sortable">
                                        Role Name 
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'name'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th>Users Count</th>
                                    <th>Permissions Count</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="role-icon me-3">
                                                    <!--[if BLOCK]><![endif]--><?php if($role->name === 'Owner'): ?>
                                                        <i class="fas fa-crown text-warning"></i>
                                                    <?php elseif($role->name === 'Administrator'): ?>
                                                        <i class="fas fa-user-shield text-primary"></i>
                                                    <?php elseif($role->name === 'LLN Specialist'): ?>
                                                        <i class="fas fa-user-graduate text-info"></i>
                                                    <?php elseif($role->name === 'Enrolment Officer'): ?>
                                                        <i class="fas fa-user-tie text-success"></i>
                                                    <?php elseif($role->name === 'Student'): ?>
                                                        <i class="fas fa-user text-secondary"></i>
                                                    <?php else: ?>
                                                        <i class="fas fa-user-circle text-muted"></i>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
<div>
                                                    <strong><?php echo e($role->name); ?></strong>
                                                    <!--[if BLOCK]><![endif]--><?php if($role->name === 'Owner'): ?>
                                                        <span class="badge bg-warning ms-2">Protected</span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?php echo e($role->users()->count()); ?> users
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">
                                                <?php echo e($role->permissions()->count()); ?> permissions
                                            </span>
                                        </td>
                                        <td><?php echo e($role->created_at->format('M d, Y')); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.edit')): ?>
                                                <a href="<?php echo e(route('admin.roles.edit', $role->id)); ?>" 
                                                   class="btn btn-sm btn-outline-primary" 
                                                   title="Edit Role">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <?php endif; ?>
                                                
                                                <!--[if BLOCK]><![endif]--><?php if($role->name !== 'Owner'): ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.delete')): ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger" 
                                                            wire:click="delete(<?php echo e($role->id); ?>)"
                                                            wire:confirm="Are you sure you want to delete this role? This action cannot be undone."
                                                            title="Delete Role">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    <?php endif; ?>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-user-tag fa-3x mb-3"></i>
                                                <p>No roles found</p>
                                                <!--[if BLOCK]><![endif]--><?php if($search): ?>
                                                    <p>Try adjusting your search criteria</p>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <!--[if BLOCK]><![endif]--><?php if($roles->hasPages()): ?>
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($roles->links()); ?>

                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Card View -->
    <!--[if BLOCK]><![endif]--><?php if($roles->count() > 0): ?>
        <div class="d-lg-none">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-3">
                    <div class="card-body p-3">
                        <div class="row align-items-start mb-3">
                            <div class="col-auto">
                                <!--[if BLOCK]><![endif]--><?php if($role->name === 'Owner'): ?>
                                    <i class="fas fa-crown text-warning fa-2x"></i>
                                <?php elseif($role->name === 'Administrator'): ?>
                                    <i class="fas fa-user-shield text-primary fa-2x"></i>
                                <?php elseif($role->name === 'LLN Specialist'): ?>
                                    <i class="fas fa-user-graduate text-info fa-2x"></i>
                                <?php elseif($role->name === 'Enrolment Officer'): ?>
                                    <i class="fas fa-user-tie text-success fa-2x"></i>
                                <?php elseif($role->name === 'Student'): ?>
                                    <i class="fas fa-user text-secondary fa-2x"></i>
                                <?php else: ?>
                                    <i class="fas fa-user-circle text-muted fa-2x"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col">
                                <h6 class="card-title mb-1 fw-semibold"><?php echo e($role->name); ?></h6>
                                <div class="d-flex flex-wrap gap-2 mb-2">
                                    <span class="badge bg-info"><?php echo e($role->users()->count()); ?> users</span>
                                    <span class="badge bg-secondary"><?php echo e($role->permissions()->count()); ?> permissions</span>
                                    <!--[if BLOCK]><![endif]--><?php if($role->name === 'Owner'): ?>
                                        <span class="badge bg-warning">Protected</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <small class="text-muted">Created: <?php echo e($role->created_at->format('M d, Y')); ?></small>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row g-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.edit')): ?>
                            <div class="col-6">
                                <a href="<?php echo e(route('admin.roles.edit', $role->id)); ?>" 
                                   class="btn btn-sm btn-outline-primary w-100">
                                    <i class="fas fa-edit me-1"></i>Edit
                                </a>
                            </div>
                            <?php endif; ?>
                            <!--[if BLOCK]><![endif]--><?php if($role->name !== 'Owner'): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.delete')): ?>
                                <div class="col-6">
                                    <button type="button" 
                                            class="btn btn-sm btn-outline-danger w-100" 
                                            wire:click="delete(<?php echo e($role->id); ?>)"
                                            wire:confirm="Are you sure you want to delete this role? This action cannot be undone.">
                                        <i class="fas fa-trash me-1"></i>Delete
                                    </button>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            
            <!-- Mobile Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($roles->hasPages()): ?>
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($roles->links()); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/role-management.blade.php ENDPATH**/ ?>