<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="LLN Quiz Portal - Student Learning Platform">
    <meta name="author" content="LLN Project">
    <meta name="keywords" content="quiz, learning, education, student, portal, lln">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>" />
    
    <title>Register - <?php echo e(\App\Models\Setting::get('site_name', config('app.name', 'LLN Quiz Portal'))); ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="<?php echo e(asset('css/auth.css')); ?>" rel="stylesheet">

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>

<body>
    <div class="auth-container">
        <!-- Floating Elements -->
        <div class="floating-elements">
            <div class="floating-element"></div>
            <div class="floating-element"></div>
            <div class="floating-element"></div>
        </div>

        <div class="auth-card">
            <!-- Auth Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <?php
                        $logoPath = \App\Models\Setting::get('site_logo');
                        $logoUrl = $logoPath ? \Storage::url($logoPath) : null;
                    ?>
                    <?php if($logoUrl && \Storage::disk('public')->exists($logoPath)): ?>
                        <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(\App\Models\Setting::get('site_name', config('app.name'))); ?> Logo" class="img-fluid">
                    <?php else: ?>
                        <div class="default-logo">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <h1 class="auth-title">Get Started!</h1>
                <p class="auth-subtitle">Create your account and start learning today</p>
            </div>

            <!-- Auth Body -->
            <div class="auth-body">
                <!-- Validation errors -->
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle"></i>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($error); ?><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <!-- Register Form -->
                <form method="POST" action="<?php echo e(route('register')); ?>" id="registerForm">
                    <?php echo csrf_field(); ?>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="name">
                                <i class="fas fa-user me-1"></i>
                                Full Name
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <input
                                id="name"
                                class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                type="text"
                                name="name"
                                placeholder="Enter your full name"
                                value="<?php echo e(old('name')); ?>"
                                required
                                autofocus
                            />
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="email">
                                <i class="fas fa-envelope me-1"></i>
                                Email Address
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <input
                                id="email"
                                class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                type="email"
                                name="email"
                                placeholder="Enter your email address"
                                value="<?php echo e(old('email')); ?>"
                                required
                            />
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="password">
                                <i class="fas fa-lock me-1"></i>
                                Password
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <div class="input-group">
                                <input
                                    id="password"
                                    class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    type="password"
                                    name="password"
                                    placeholder="Create a strong password"
                                    required
                                    autocomplete="new-password"
                                />
                                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="password_confirmation">
                                <i class="fas fa-lock me-1"></i>
                                Confirm Password
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <div class="input-group">
                                <input
                                    id="password_confirmation"
                                    class="form-control"
                                    type="password"
                                    name="password_confirmation"
                                    placeholder="Confirm your password"
                                    required
                                    autocomplete="new-password"
                                />
                                <button class="btn btn-outline-secondary" type="button" id="togglePasswordConfirmation">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="form-check mb-4">
                        <input id="terms" type="checkbox" class="form-check-input" name="terms" required>
                        <label class="form-check-label" for="terms">
                            I agree to the <a href="#" class="auth-link">Terms of Service</a> and <a href="#" class="auth-link">Privacy Policy</a>
                        </label>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn-auth btn-primary-auth" id="registerBtn">
                            <i class="fas fa-user-plus me-2"></i>
                            Create Account
                        </button>
                    </div>
                </form>
            </div>

            <!-- Auth Footer -->
            <div class="auth-footer">
                <div class="auth-footer-text">
                    Already have an account?
                    <a href="<?php echo e(route('login')); ?>" class="auth-link">Sign in here</a>
                </div>
                <p class="auth-copyright">
                    <?php echo e(\App\Models\Setting::get('copyright_text', '© ' . date('Y') . ' LLN Quiz Portal. All rights reserved.')); ?>

                </p>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- JavaScript -->
    <script>
        // Form submission with loading state
        document.getElementById('registerForm').addEventListener('submit', function() {
            const btn = document.getElementById('registerBtn');
            btn.classList.add('loading');
            btn.disabled = true;
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s ease';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);

        // Password confirmation validation
        const password = document.getElementById('password');
        const passwordConfirmation = document.getElementById('password_confirmation');

        function validatePasswordMatch() {
            if (password.value !== passwordConfirmation.value) {
                passwordConfirmation.setCustomValidity('Passwords do not match');
            } else {
                passwordConfirmation.setCustomValidity('');
            }
        }

        password.addEventListener('change', validatePasswordMatch);
        passwordConfirmation.addEventListener('keyup', validatePasswordMatch);

        // Password toggle functionality
        function setupPasswordToggle(toggleId, inputId) {
            const toggleBtn = document.getElementById(toggleId);
            const passwordInput = document.getElementById(inputId);
            
            if (toggleBtn && passwordInput) {
                toggleBtn.addEventListener('click', function() {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    
                    const icon = toggleBtn.querySelector('i');
                    icon.classList.toggle('fa-eye');
                    icon.classList.toggle('fa-eye-slash');
                });
            }
        }

        // Setup password toggles
        setupPasswordToggle('togglePassword', 'password');
        setupPasswordToggle('togglePasswordConfirmation', 'password_confirmation');

        // Add focus effects to form controls
        const formControls = document.querySelectorAll('.form-control');
        formControls.forEach(function(control) {
            control.addEventListener('focus', function() {
                this.parentElement.classList.add('focused');
            });
            
            control.addEventListener('blur', function() {
                if (!this.value) {
                    this.parentElement.classList.remove('focused');
                }
            });
        });

        // Real-time password strength indicator
        password.addEventListener('input', function() {
            const strength = getPasswordStrength(this.value);
            const strengthIndicator = document.getElementById('password-strength') || createStrengthIndicator();
            updateStrengthIndicator(strengthIndicator, strength);
        });

        function createStrengthIndicator() {
            const indicator = document.createElement('div');
            indicator.id = 'password-strength';
            indicator.className = 'password-strength';
            password.parentElement.appendChild(indicator);
            return indicator;
        }

        function getPasswordStrength(password) {
            let strength = 0;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password)) strength++;
            if (/[A-Z]/.test(password)) strength++;
            if (/[0-9]/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;
            return strength;
        }

        function updateStrengthIndicator(indicator, strength) {
            const levels = ['Very Weak', 'Weak', 'Fair', 'Good', 'Strong'];
            const colors = ['#ef4444', '#f59e0b', '#f59e0b', '#10b981', '#10b981'];
            
            indicator.innerHTML = `
                <div class="strength-bar">
                    <div class="strength-fill" style="width: ${(strength / 5) * 100}%; background-color: ${colors[strength - 1] || '#e5e7eb'};"></div>
                </div>
                <span class="strength-text" style="color: ${colors[strength - 1] || '#6b7280'};">${levels[strength - 1] || 'Enter password'}</span>
            `;
        }
    </script>

    <style>
        .password-strength {
            margin-top: 0.5rem;
        }
        
        .strength-bar {
            width: 100%;
            height: 4px;
            background-color: #e5e7eb;
            border-radius: 2px;
            overflow: hidden;
            margin-bottom: 0.25rem;
        }
        
        .strength-fill {
            height: 100%;
            transition: width 0.3s ease, background-color 0.3s ease;
        }
        
        .strength-text {
            font-size: 0.75rem;
            font-weight: 500;
        }
    </style>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

</body>
</html><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/Admin/auth/register.blade.php ENDPATH**/ ?>