<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-question-circle"></i>
                Quiz Management
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-question-circle me-1"></i>Quizzes
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="mb-0"><?php echo e($quizzes->total()); ?></h4>
                            <small>Total Quizzes</small>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-clipboard fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="mb-0"><?php echo e($quizzes->where('status', 'published')->count()); ?></h4>
                            <small>Published</small>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-check-circle fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="mb-0"><?php echo e($quizzes->where('status', 'draft')->count()); ?></h4>
                            <small>Drafts</small>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-edit fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="mb-0"><?php echo e($quizzes->sum('total_questions')); ?></h4>
                            <small>Total Questions</small>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-question-circle fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="search" class="form-label">Search</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="search" 
                                   wire:model.live.debounce.300ms="search" 
                                   placeholder="Search quizzes...">
                        </div>
                        <div class="col-md-3">
                            <label for="statusFilter" class="form-label">Status</label>
                            <select class="form-select" id="statusFilter" wire:model.live="statusFilter">
                                <option value="">All Statuses</option>
                                <option value="draft">Draft</option>
                                <option value="published">Published</option>
                                <option value="archived">Archived</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="visibilityFilter" class="form-label">Visibility</label>
                            <select class="form-select" id="visibilityFilter" wire:model.live="visibilityFilter">
                                <option value="">All Visibility</option>
                                <option value="private">Private</option>
                                <option value="public">Public</option>
                                <option value="unlisted">Unlisted</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="perPage" class="form-label">Per Page</label>
                            <select class="form-select" id="perPage" wire:model.live="perPage">
                                <option value="5">5</option>
                                <option value="10">10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <button type="button" 
                                    class="btn btn-outline-secondary" 
                                    wire:click="clearFilters">
                                <i class="fas fa-times me-1"></i>Clear Filters
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quizzes Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list me-2"></i>Quizzes
                        <span class="badge bg-primary ms-2"><?php echo e($quizzes->total()); ?></span>
                    </h5>
                    <div class="d-flex gap-2">
                        <a href="<?php echo e(route('admin.quizzes.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Create Quiz
                        </a>
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-cog me-1"></i>Quick Actions
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#" onclick="alert('Bulk actions coming soon!')">
                                    <i class="fas fa-check-square me-2"></i>Bulk Select
                                </a></li>
                                <li><a class="dropdown-item" href="#" onclick="alert('Export feature coming soon!')">
                                    <i class="fas fa-download me-2"></i>Export Quizzes
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="#" onclick="alert('Import feature coming soon!')">
                                    <i class="fas fa-upload me-2"></i>Import Quizzes
                                </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th wire:click="sortBy('title')" style="cursor: pointer;">
                                        Title
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'title'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                        <?php else: ?>
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th>Questions</th>
                                    <th>Status</th>
                                    <th>Visibility</th>
                                    <th>Creator</th>
                                    <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                        Created
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'created_at'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                        <?php else: ?>
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $quizzes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="quiz-icon me-3">
                                                <i class="fas fa-question-circle text-primary"></i>
                                            </div>
<div>
                                                <h6 class="mb-0"><?php echo e($quiz->title); ?></h6>
                                                <!--[if BLOCK]><![endif]--><?php if($quiz->description): ?>
                                                    <small class="text-muted"><?php echo e(Str::limit($quiz->description, 50)); ?></small>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($quiz->total_questions); ?></span>
                                    </td>
                                    <td>
                                        <!--[if BLOCK]><![endif]--><?php switch($quiz->status):
                                            case ('draft'): ?>
                                                <span class="badge bg-secondary">Draft</span>
                                                <?php break; ?>
                                            <?php case ('published'): ?>
                                                <span class="badge bg-success">Published</span>
                                                <?php break; ?>
                                            <?php case ('archived'): ?>
                                                <span class="badge bg-warning">Archived</span>
                                                <?php break; ?>
                                        <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                    <td>
                                        <!--[if BLOCK]><![endif]--><?php switch($quiz->visibility):
                                            case ('private'): ?>
                                                <span class="badge bg-danger">Private</span>
                                                <?php break; ?>
                                            <?php case ('public'): ?>
                                                <span class="badge bg-success">Public</span>
                                                <?php break; ?>
                                            <?php case ('unlisted'): ?>
                                                <span class="badge bg-warning">Unlisted</span>
                                                <?php break; ?>
                                        <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-size: 14px;">
                                                <?php echo e(substr($quiz->creator->name ?? 'U', 0, 1)); ?>

                                            </div>
                                            <span><?php echo e($quiz->creator->name ?? 'Unknown'); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($quiz->created_at->format('M d, Y')); ?></small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.quizzes.show', $quiz)); ?>" 
                                               class="btn btn-sm btn-outline-info" 
                                               title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.quizzes.edit', $quiz)); ?>" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.quizzes.questions', $quiz)); ?>" 
                                               class="btn btn-sm btn-outline-success" 
                                               title="Manage Questions (<?php echo e($quiz->total_questions); ?> questions)"
                                               data-bs-toggle="tooltip" 
                                               data-bs-placement="top">
                                                <i class="fas fa-question-circle"></i>
                                            </a>
                                            <!--[if BLOCK]><![endif]--><?php if($quiz->status === 'draft'): ?>
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-success" 
                                                        wire:click="publishQuiz(<?php echo e($quiz->id); ?>)"
                                                        title="Publish">
                                                    <i class="fas fa-publish"></i>
                                                </button>
                                            <?php elseif($quiz->status === 'published'): ?>
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-warning" 
                                                        wire:click="unpublishQuiz(<?php echo e($quiz->id); ?>)"
                                                        title="Unpublish">
                                                    <i class="fas fa-unpublish"></i>
                                                </button>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <button type="button" 
                                                    class="btn btn-sm btn-outline-danger" 
                                                    wire:click="deleteQuiz(<?php echo e($quiz->id); ?>)"
                                                    onclick="return confirm('Are you sure you want to delete this quiz?')"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-question-circle fa-3x mb-3"></i>
                                            <p>No quizzes found</p>
                                            <a href="<?php echo e(route('admin.quizzes.create')); ?>" class="btn btn-primary">
                                                <i class="fas fa-plus me-1"></i>Create Your First Quiz
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <?php echo e($quizzes->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Mobile View -->
    <div class="row d-lg-none">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-mobile-alt me-2"></i>Mobile View
                    </h5>
                </div>
                <div class="card-body">
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $quizzes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="card-title mb-0"><?php echo e($quiz->title); ?></h6>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.quizzes.show', $quiz)); ?>">
                                            <i class="fas fa-eye me-2"></i>View
                                        </a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.quizzes.edit', $quiz)); ?>">
                                            <i class="fas fa-edit me-2"></i>Edit
                                        </a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.quizzes.questions', $quiz)); ?>">
                                            <i class="fas fa-question-circle me-2"></i>Manage Questions
                                        </a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <!--[if BLOCK]><![endif]--><?php if($quiz->status === 'draft'): ?>
                                            <li><a class="dropdown-item" href="#" wire:click="publishQuiz(<?php echo e($quiz->id); ?>)">
                                                <i class="fas fa-publish me-2"></i>Publish
                                            </a></li>
                                        <?php elseif($quiz->status === 'published'): ?>
                                            <li><a class="dropdown-item" href="#" wire:click="unpublishQuiz(<?php echo e($quiz->id); ?>)">
                                                <i class="fas fa-unpublish me-2"></i>Unpublish
                                            </a></li>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <li><a class="dropdown-item text-danger" href="#" wire:click="deleteQuiz(<?php echo e($quiz->id); ?>)" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash me-2"></i>Delete
                                        </a></li>
                                    </ul>
                                </div>
                            </div>
                            
                            <!--[if BLOCK]><![endif]--><?php if($quiz->description): ?>
                                <p class="card-text text-muted small"><?php echo e(Str::limit($quiz->description, 100)); ?></p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <div class="row g-2 mb-2">
                                <div class="col-6">
                                    <small class="text-muted">Questions:</small>
                                    <span class="badge bg-info"><?php echo e($quiz->total_questions); ?></span>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Status:</small>
                                    <!--[if BLOCK]><![endif]--><?php switch($quiz->status):
                                        case ('draft'): ?>
                                            <span class="badge bg-secondary">Draft</span>
                                            <?php break; ?>
                                        <?php case ('published'): ?>
                                            <span class="badge bg-success">Published</span>
                                            <?php break; ?>
                                        <?php case ('archived'): ?>
                                            <span class="badge bg-warning">Archived</span>
                                            <?php break; ?>
                                    <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
</div>

                            <div class="row g-2">
                                <div class="col-6">
                                    <small class="text-muted">Visibility:</small>
                                    <!--[if BLOCK]><![endif]--><?php switch($quiz->visibility):
                                        case ('private'): ?>
                                            <span class="badge bg-danger">Private</span>
                                            <?php break; ?>
                                        <?php case ('public'): ?>
                                            <span class="badge bg-success">Public</span>
                                            <?php break; ?>
                                        <?php case ('unlisted'): ?>
                                            <span class="badge bg-warning">Unlisted</span>
                                            <?php break; ?>
                                    <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Created:</small>
                                    <small><?php echo e($quiz->created_at->format('M d, Y')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                        <p class="text-muted">No quizzes found</p>
                        <a href="<?php echo e(route('admin.quizzes.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Create Your First Quiz
                        </a>
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="card-footer">
                    <?php echo e($quizzes->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/quiz-management.blade.php ENDPATH**/ ?>