<div>
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">Quiz Invitations</h4>
            <p class="text-muted mb-0">Manage invitations for "<?php echo e($quiz->title); ?>"</p>
        </div>
        <div>
            <button type="button" class="btn btn-primary" wire:click="toggleInviteForm">
                <i class="fas fa-envelope me-2"></i>Send Invitations
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1"><?php echo e($stats['total']); ?></h3>
                    <small>Total</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1"><?php echo e($stats['pending']); ?></h3>
                    <small>Pending</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-info text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1"><?php echo e($stats['sent']); ?></h3>
                    <small>Sent</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1"><?php echo e($stats['opened']); ?></h3>
                    <small>Opened</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1"><?php echo e($stats['completed']); ?></h3>
                    <small>Completed</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Invitation Form Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showInviteForm): ?>
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Send New Invitations</h5>
        </div>
        <div class="card-body">
            <form wire:submit.prevent="sendInvitations">
                <div class="mb-3">
                    <label for="emails" class="form-label">Email Addresses</label>
                    <textarea 
                        class="form-control <?php $__errorArgs = ['emails'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                        id="emails" 
                        rows="3" 
                        wire:model="emails"
                        placeholder="Enter email addresses separated by commas (e.g., user1@example.com, user2@example.com)"
                    ></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['emails'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    <div class="form-text">Separate multiple email addresses with commas</div>
                </div>

                <div class="mb-3">
                    <label for="customMessage" class="form-label">Personal Message (Optional)</label>
                    <textarea 
                        class="form-control <?php $__errorArgs = ['customMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                        id="customMessage" 
                        rows="3" 
                        wire:model="customMessage"
                        placeholder="Add a personal message to include in the invitation email"
                    ></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane me-2"></i>Send Invitations
                    </button>
                    <button type="button" class="btn btn-secondary" wire:click="toggleInviteForm">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Filters and Search -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <input 
                        type="text" 
                        class="form-control" 
                        placeholder="Search by email..." 
                        wire:model.live.debounce.300ms="search"
                    >
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="statusFilter">
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="sent">Sent</option>
                        <option value="opened">Opened</option>
                        <option value="completed">Completed</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="sortField">
                        <option value="created_at">Sort by Date</option>
                        <option value="email">Sort by Email</option>
                        <option value="status">Sort by Status</option>
                        <option value="sent_at">Sort by Sent Date</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-outline-secondary w-100" wire:click="clearFilters">
                        <i class="fas fa-times me-2"></i>Clear
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Invitations Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Invitations</h5>
            <!--[if BLOCK]><![endif]--><?php if(count($selectedInvitations) > 0): ?>
                <button type="button" class="btn btn-danger btn-sm" wire:click="bulkDelete">
                    <i class="fas fa-trash me-2"></i>Delete Selected (<?php echo e(count($selectedInvitations)); ?>)
                </button>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>
                                <input 
                                    type="checkbox" 
                                    class="form-check-input" 
                                    wire:click="toggleSelectAll"
                                    <?php if(count($selectedInvitations) === $invitations->count() && $invitations->count() > 0): ?> checked <?php endif; ?>
                                >
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('email')" class="text-decoration-none">
                                    Email
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'email'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('status')" class="text-decoration-none">
                                    Status
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'status'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('sent_at')" class="text-decoration-none">
                                    Sent Date
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'sent_at'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('opened_at')" class="text-decoration-none">
                                    Opened Date
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'opened_at'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('completed_at')" class="text-decoration-none">
                                    Completed Date
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'completed_at'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?> ms-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invitation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        class="form-check-input" 
                                        value="<?php echo e($invitation->id); ?>"
                                        wire:model="selectedInvitations"
                                    >
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-envelope me-2 text-muted"></i>
                                        <?php echo e($invitation->email); ?>

                                    </div>
                                </td>
                                <td>
                                    <?php
                                        $statusConfig = [
                                            'pending' => ['class' => 'bg-warning', 'text' => 'Pending'],
                                            'sent' => ['class' => 'bg-info', 'text' => 'Sent'],
                                            'opened' => ['class' => 'bg-secondary', 'text' => 'Opened'],
                                            'completed' => ['class' => 'bg-success', 'text' => 'Completed'],
                                        ];
                                        $config = $statusConfig[$invitation->status] ?? ['class' => 'bg-light', 'text' => ucfirst($invitation->status)];
                                    ?>
                                    <span class="badge <?php echo e($config['class']); ?>"><?php echo e($config['text']); ?></span>
                                </td>
                                <td>
                                    <!--[if BLOCK]><![endif]--><?php if($invitation->sent_at): ?>
                                        <?php echo e($invitation->sent_at->format('M j, Y g:i A')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td>
                                    <!--[if BLOCK]><![endif]--><?php if($invitation->opened_at): ?>
                                        <?php echo e($invitation->opened_at->format('M j, Y g:i A')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td>
                                    <!--[if BLOCK]><![endif]--><?php if($invitation->completed_at): ?>
                                        <?php echo e($invitation->completed_at->format('M j, Y g:i A')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <!--[if BLOCK]><![endif]--><?php if($invitation->status !== 'completed'): ?>
                                            <button 
                                                type="button" 
                                                class="btn btn-outline-primary" 
                                                wire:click="resendInvitation(<?php echo e($invitation->id); ?>)"
                                                title="Resend Invitation"
                                            >
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <button 
                                            type="button" 
                                            class="btn btn-outline-danger" 
                                            wire:click="deleteInvitation(<?php echo e($invitation->id); ?>)"
                                            onclick="return confirm('Are you sure you want to delete this invitation?')"
                                            title="Delete Invitation"
                                        >
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <p class="mb-0">No invitations found</p>
                                        <small>Send your first invitation using the button above</small>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
        </div>
        <!--[if BLOCK]><![endif]--><?php if($invitations->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($invitations->links()); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div>
<?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/quiz-invitation-management.blade.php ENDPATH**/ ?>